/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.nbt;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.FDTagDeserializers;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.nbt.TagDeserializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class TagSerializationHelper {
    public static <T extends AutoSerializable> void saveFields(CompoundTag tag, T object) {
        Class<?> clazz = object.getClass();
        List<Field> fields = FDHelpers.getAllAnnotatedFieldsInClass(clazz, SerializableField.class);
        for (Field field : fields) {
            field.setAccessible(true);
            TagSerializationHelper.saveField(object, tag, field);
        }
    }

    public static <T extends AutoSerializable> void loadFields(CompoundTag tag, T object) {
        Class<?> clazz = object.getClass();
        List<Field> fields = FDHelpers.getAllAnnotatedFieldsInClass(clazz, SerializableField.class);
        for (Field field : fields) {
            field.setAccessible(true);
            TagSerializationHelper.loadField(object, tag, field);
        }
    }

    private static <T extends AutoSerializable> void saveField(T object, CompoundTag tag, Field field) {
        try {
            Class<?> clazz = field.getType();
            String name = field.getName();
            Object value = field.get(object);
            if (clazz.isEnum()) {
                tag.m_128359_(name, ((Enum)value).name());
            } else if (value instanceof Integer) {
                Integer i = (Integer)value;
                tag.m_128405_(name, i.intValue());
            } else if (value instanceof Float) {
                Float f = (Float)value;
                tag.m_128350_(name, f.floatValue());
            } else if (value instanceof Double) {
                Double d = (Double)value;
                tag.m_128347_(name, d.doubleValue());
            } else if (value instanceof Boolean) {
                Boolean d = (Boolean)value;
                tag.m_128379_(name, d.booleanValue());
            } else if (value instanceof String) {
                String s = (String)value;
                tag.m_128359_(name, s);
            } else if (value instanceof UUID) {
                UUID uuid = (UUID)value;
                tag.m_128362_(name, uuid);
            } else if (value instanceof Tag) {
                Tag t = (Tag)value;
                tag.m_128365_(name, t);
            } else if (value != null) {
                if (value instanceof AutoSerializable) {
                    AutoSerializable autoSerializable = (AutoSerializable)value;
                    CompoundTag t = new CompoundTag();
                    autoSerializable.autoSave(t);
                    tag.m_128365_(name, (Tag)t);
                } else if (FDTagDeserializers.DESERIALIZERS.containsKey(clazz)) {
                    TagDeserializer<?> deserializer = FDTagDeserializers.DESERIALIZERS.get(clazz);
                    TagSerializationHelper.hackyUseSerializer(name, deserializer, value, tag);
                } else {
                    FDLib.LOGGER.error("Deserializer for field: " + name + " in class " + object.getClass() + " not found.");
                }
            }
        }
        catch (Exception e) {
            FDLib.LOGGER.error("Failed to serialize field in " + object.getClass() + " class: " + field.getName());
            e.printStackTrace();
        }
    }

    private static <T extends AutoSerializable> void loadField(T object, CompoundTag tag, Field field) {
        block18: {
            try {
                String name = field.getName();
                Class<?> fieldType = field.getType();
                if (!tag.m_128441_(name)) {
                    return;
                }
                if (fieldType.isEnum()) {
                    String enumName = tag.m_128461_(name);
                    for (Object en : fieldType.getEnumConstants()) {
                        Enum enums = (Enum)en;
                        if (!enums.name().equals(enumName)) continue;
                        field.set(object, enums);
                        break block18;
                    }
                    break block18;
                }
                if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128451_(name));
                    break block18;
                }
                if (Float.class.isAssignableFrom(fieldType) || Float.TYPE.isAssignableFrom(fieldType)) {
                    field.set(object, Float.valueOf(tag.m_128457_(name)));
                    break block18;
                }
                if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128459_(name));
                    break block18;
                }
                if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128471_(name));
                    break block18;
                }
                if (String.class.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128461_(name));
                    break block18;
                }
                if (UUID.class.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128342_(name));
                    break block18;
                }
                if (Tag.class.isAssignableFrom(fieldType)) {
                    field.set(object, tag.m_128423_(name));
                    break block18;
                }
                if (AutoSerializable.class.isAssignableFrom(fieldType)) {
                    CompoundTag t = tag.m_128469_(name);
                    AutoSerializable serializable = (AutoSerializable)field.get(object);
                    if (serializable == null) {
                        try {
                            Constructor<?> constructor = fieldType.getConstructor(new Class[0]);
                            serializable = (AutoSerializable)constructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Tried to load an uninitialized AutoSerializable field. All fields that implement that interface should be initialized or at least have a zero-argument constructor!");
                        }
                    }
                    serializable.autoLoad(t);
                    field.set(object, serializable);
                    break block18;
                }
                Class<?> clazz = field.getType();
                if (FDTagDeserializers.DESERIALIZERS.containsKey(clazz)) {
                    TagDeserializer<?> deserializer = FDTagDeserializers.DESERIALIZERS.get(clazz);
                    Object value = TagSerializationHelper.hackyUseDeserializer(name, deserializer, tag);
                    field.set(object, value);
                } else {
                    FDLib.LOGGER.error("Deserializer for field: " + name + " in class " + object.getClass() + " not found.");
                }
            }
            catch (Exception e) {
                FDLib.LOGGER.error("Failed to serialize field in " + object.getClass() + " class: " + field.getName());
                e.printStackTrace();
            }
        }
    }

    private static <T> void hackyUseSerializer(String name, TagDeserializer<T> deserializer, Object object, CompoundTag tag) {
        deserializer.serialize(name, object, tag);
    }

    private static <T> T hackyUseDeserializer(String name, TagDeserializer<T> deserializer, CompoundTag tag) {
        return deserializer.deserialize(name, tag);
    }
}

