/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.commands;

import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.commands.AnimationArgument;
import com.finderfeed.fdlib.init.FDModEvents;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.TriggerAnimationReloadPacket;
import com.finderfeed.fdlib.systems.bedrock.TriggerModelReloadPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.packets.JsonConfigSyncPacket;
import com.finderfeed.fdlib.systems.config.packets.TriggerClientsideConfigReloadPacket;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FDCommandsRegistry {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fdlib").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"animation_test").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"animation", (ArgumentType)new AnimationArgument()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"layer", (ArgumentType)StringArgumentType.string()).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            FDCommandsRegistry.executeEntityAnimation((CommandContext<CommandSourceStack>)context, (String)context.getArgument("animation", String.class), (String)context.getArgument("layer", String.class), EntityArgument.m_91452_((CommandContext)context, (String)"target"));
            return 1;
        })))).then(Commands.m_82127_((String)"tile").then(Commands.m_82129_((String)"target", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            FDCommandsRegistry.executeTileEntityAnimation((CommandContext<CommandSourceStack>)context, (String)context.getArgument("animation", String.class), (String)context.getArgument("layer", String.class), BlockPosArgument.m_264582_((CommandContext)context, (String)"target"));
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").then(Commands.m_82127_((String)"clientsideConfigs").executes(ctx -> {
            FDCommandsRegistry.reloadClientConfigs((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"configs").requires(stack -> stack.m_6761_(2))).executes(ctx -> {
            FDCommandsRegistry.reloadConfigs((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"models").requires(stack -> stack.m_6761_(2))).executes(ctx -> {
            FDCommandsRegistry.reloadModels((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"animations").requires(stack -> stack.m_6761_(2))).executes(ctx -> {
            FDCommandsRegistry.reloadAnimations((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })))).then(Commands.m_82127_((String)"fix").then(Commands.m_82127_((String)"cutscene").executes(stack -> {
            FDCommandsRegistry.emergencyCutsceneEnd((CommandContext<CommandSourceStack>)stack);
            return 1;
        }))));
    }

    public static void emergencyCutsceneEnd(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = stack.m_81375_();
        FDLibCalls.stopCutsceneForPlayer(player);
    }

    public static void reloadAnimations(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        if (!SharedConstants.f_136183_) {
            // empty if block
        }
        stack.m_243053_((Component)Component.m_237113_((String)"Reloading animations..."));
        FDModEvents.loadAnimations();
        FDPacketHandler.INSTANCE.send(PacketDistributor.ALL.with(() -> null), (Object)new TriggerAnimationReloadPacket());
        stack.m_243053_((Component)Component.m_237113_((String)"Reload complete!"));
    }

    public static void reloadModels(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        if (!SharedConstants.f_136183_) {
            // empty if block
        }
        stack.m_243053_((Component)Component.m_237113_((String)"Reloading models..."));
        FDModEvents.loadModels();
        FDPacketHandler.INSTANCE.send(PacketDistributor.ALL.with(() -> null), (Object)new TriggerModelReloadPacket());
        stack.m_243053_((Component)Component.m_237113_((String)"Reload complete!"));
    }

    public static void reloadConfigs(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        for (JsonConfig config : FDRegistries.CONFIGS.get()) {
            if (config.isClientside()) continue;
            stack.m_243053_((Component)Component.m_237113_((String)("Loading config: " + config.getName())));
            config.loadFromDisk();
            stack.m_243053_((Component)Component.m_237113_((String)("Loaded config: " + config.getName())).m_130940_(ChatFormatting.GREEN));
        }
        FDPacketHandler.INSTANCE.send(PacketDistributor.ALL.with(() -> null), (Object)new JsonConfigSyncPacket());
    }

    public static void reloadClientConfigs(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        FDPacketHandler.INSTANCE.sendTo((Object)new TriggerClientsideConfigReloadPacket(true), ((CommandSourceStack)ctx.getSource()).m_81375_().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void executeEntityAnimation(CommandContext<CommandSourceStack> ctx, String animname, String tickerName, Entity entity) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)ctx.getSource();
        Animation animation = (Animation)FDRegistries.ANIMATIONS.get().getValue(ResourceLocation.m_135820_((String)animname));
        if (animation == null) {
            sourceStack.m_81352_((Component)Component.m_237113_((String)("No such animation found: " + animname)));
            return;
        }
        if (!(entity instanceof AnimatedObject)) {
            sourceStack.m_81352_((Component)Component.m_237113_((String)"Entity is not an animatable object"));
            return;
        }
        AnimatedObject object = (AnimatedObject)entity;
        sourceStack.m_243053_((Component)Component.m_237113_((String)"Playing animation"));
        object.getAnimationSystem().startAnimation(tickerName, new AnimationTicker.Builder(animation).setLoopMode(Animation.LoopMode.ONCE).setToNullTransitionTime(0).build());
    }

    public static void executeTileEntityAnimation(CommandContext<CommandSourceStack> ctx, String animname, String tickerName, BlockPos pos) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)ctx.getSource();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        Animation animation = (Animation)FDRegistries.ANIMATIONS.get().getValue(ResourceLocation.m_135820_((String)animname));
        if (animation == null) {
            sourceStack.m_81352_((Component)Component.m_237113_((String)("No such animation found: " + animname)));
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            sourceStack.m_81352_((Component)Component.m_237113_((String)"Tile entity is not an animatable object"));
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        sourceStack.m_243053_((Component)Component.m_237113_((String)"Playing animation"));
        object.getAnimationSystem().startAnimation(tickerName, new AnimationTicker.Builder(animation).setLoopMode(Animation.LoopMode.ONCE).setToNullTransitionTime(0).build());
    }
}

