/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block.entity;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SuspiciousAncientSandBlockEntity
extends BlockEntity {
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private ItemStack item = ItemStack.f_41583_;
    @Nullable
    private Direction hitDirection;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public SuspiciousAncientSandBlockEntity(BlockPos $$0, BlockState $$1) {
        super((BlockEntityType)EntityTypeModule.SUSPICIOUS_ANCIENT_SAND.get(), $$0, $$1);
    }

    public boolean brush(long $$0, Player $$1, Direction $$2) {
        if (this.hitDirection == null) {
            this.hitDirection = $$2;
        }
        this.brushCountResetsAtTick = $$0 + 40L;
        if ($$0 >= this.coolDownEndsAtTick && this.f_58857_ instanceof ServerLevel) {
            this.coolDownEndsAtTick = $$0 + 10L;
            this.unpackLootTable($$1);
            int $$3 = this.getCompletionState();
            if (++this.brushCount >= 10) {
                this.brushingCompleted($$1);
                return true;
            }
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 40);
            int $$4 = this.getCompletionState();
            if ($$3 != $$4) {
                BlockState $$5 = this.m_58900_();
                BlockState $$6 = (BlockState)$$5.m_61124_((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf($$4));
                this.f_58857_.m_7731_(this.m_58899_(), $$6, 3);
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(Player $$0) {
        if (this.lootTable != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable $$1 = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if ($$0 instanceof ServerPlayer) {
                ServerPlayer $$2 = (ServerPlayer)$$0;
                CriteriaTriggers.f_10563_.m_54597_($$2, this.lootTable);
            }
            LootParams $$3 = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287239_($$0.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)$$0).m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList $$4 = $$1.m_287214_($$3, this.lootTableSeed);
            this.item = switch ($$4.size()) {
                case 0 -> ItemStack.f_41583_;
                case 1 -> (ItemStack)$$4.get(0);
                default -> {
                    YungsCaveBiomesCommon.LOGGER.warn("Expected max 1 loot from loot table {} got {}", (Object)this.lootTable, (Object)$$4.size());
                    yield (ItemStack)$$4.get(0);
                }
            };
            this.lootTable = null;
            this.m_6596_();
        }
    }

    private void brushingCompleted(Player $$0) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            Block $$4;
            this.dropContent($$0);
            BlockState $$1 = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_((BlockState)$$1));
            Block block = this.m_58900_().m_60734_();
            if (block instanceof BrushableBlock) {
                BrushableBlock $$3 = (BrushableBlock)block;
                $$4 = $$3.m_277074_();
            } else {
                $$4 = Blocks.f_50016_;
            }
            this.f_58857_.m_7731_(this.f_58858_, $$4.m_49966_(), 3);
        }
    }

    private void dropContent(Player $$0) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.unpackLootTable($$0);
            if (!this.item.m_41619_()) {
                double $$1 = EntityType.f_20461_.m_20678_();
                double $$2 = 1.0 - $$1;
                double $$3 = $$1 / 2.0;
                Direction $$4 = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                BlockPos $$5 = this.f_58858_.m_5484_($$4, 1);
                double $$6 = (double)$$5.m_123341_() + 0.5 * $$2 + $$3;
                double $$7 = (double)$$5.m_123342_() + 0.5 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double $$8 = (double)$$5.m_123343_() + 0.5 * $$2 + $$3;
                ItemEntity $$9 = new ItemEntity(this.f_58857_, $$6, $$7, $$8, this.item.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                $$9.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)$$9);
                this.item = ItemStack.f_41583_;
            }
        }
    }

    public void checkReset() {
        if (this.f_58857_ != null) {
            if (this.brushCount != 0 && this.f_58857_.m_46467_() >= this.brushCountResetsAtTick) {
                int $$0 = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int $$1 = this.getCompletionState();
                if ($$0 != $$1) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf($$1)), 3);
                }
                int $$2 = 4;
                this.brushCountResetsAtTick = this.f_58857_.m_46467_() + 4L;
            }
            if (this.brushCount == 0) {
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), (int)(this.brushCountResetsAtTick - this.f_58857_.m_46467_()));
            }
        }
    }

    private boolean tryLoadLootTable(CompoundTag $$0) {
        if ($$0.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new ResourceLocation($$0.m_128461_(LOOT_TABLE_TAG));
            this.lootTableSeed = $$0.m_128454_(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(CompoundTag $$0) {
        if (this.lootTable == null) {
            return false;
        }
        $$0.m_128359_(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            $$0.m_128356_(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag $$0 = super.m_5995_();
        if (this.hitDirection != null) {
            $$0.m_128405_(HIT_DIRECTION_TAG, this.hitDirection.ordinal());
        }
        $$0.m_128365_(ITEM_TAG, (Tag)this.item.m_41739_(new CompoundTag()));
        return $$0;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag $$0) {
        if (!this.tryLoadLootTable($$0) && $$0.m_128441_(ITEM_TAG)) {
            this.item = ItemStack.m_41712_((CompoundTag)$$0.m_128469_(ITEM_TAG));
        }
        if ($$0.m_128441_(HIT_DIRECTION_TAG)) {
            this.hitDirection = Direction.values()[$$0.m_128451_(HIT_DIRECTION_TAG)];
        }
    }

    protected void m_183515_(CompoundTag $$0) {
        if (!this.trySaveLootTable($$0)) {
            $$0.m_128365_(ITEM_TAG, (Tag)this.item.m_41739_(new CompoundTag()));
        }
    }

    public void setLootTable(ResourceLocation $$0, long $$1) {
        this.lootTable = $$0;
        this.lootTableSeed = $$1;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public Direction getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack itemStack) {
        this.item = itemStack;
    }
}

