/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import snownee.kiwi.loader.Platform;
import snownee.snow.GameEvents;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;
import snownee.snow.util.ClientProxy;

@Mod(value="snowrealmagic")
public class CommonProxy {
    public static boolean terraforged;
    public static boolean sereneseasons;

    public CommonProxy() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (SnowCommonConfig.debugSpawningCommand) {
                DebugMobSpawningCommand.m_180110_((CommandDispatcher)event.getDispatcher());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = GameEvents.onItemUse(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            if (result.m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
        sereneseasons = Platform.isModLoaded((String)"sereneseasons");
        if (sereneseasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding weather behavior.");
        }
        if (Platform.isPhysicalClient()) {
            ClientProxy.init();
        }
    }

    public static boolean isHot(FluidState fluidState, Level level, BlockPos pos) {
        return fluidState.m_76152_().getFluidType().getTemperature(fluidState, (BlockAndTintGetter)level, pos) > 380 || fluidState.m_205070_(FluidTags.f_13132_);
    }

    public static Packet<ClientGamePacketListener> getAddEntityPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    public static void weatherTick(ServerLevel level, Runnable action) {
        if (sereneseasons) {
            SereneSeasonsCompat.weatherTick(level, action);
            return;
        }
        if (level.f_46441_.m_188503_(SnowCommonConfig.weatherTickSlowness) == 0) {
            action.run();
        }
    }

    public static boolean snowAccumulationNow(Level level) {
        if (!level.m_46471_()) {
            return false;
        }
        if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
            return true;
        }
        return SnowCommonConfig.snowAccumulationDuringSnowstorm && (level.m_46470_() || sereneseasons);
    }

    @Deprecated(forRemoval=true)
    public static boolean shouldMelt(Level level, BlockPos pos) {
        return CommonProxy.shouldMeltByTemperature(level, pos);
    }

    @Deprecated(forRemoval=true)
    public static boolean shouldMelt(Level level, BlockPos pos, Holder<Biome> biome, int layers) {
        return CommonProxy.shouldMeltByTemperature(level, pos, biome, layers);
    }

    public static boolean shouldMeltByTemperature(Level level, BlockPos pos) {
        return CommonProxy.shouldMeltByTemperature(level, pos, (Holder<Biome>)level.m_204166_(pos), 1);
    }

    public static boolean shouldMeltByTemperature(Level level, BlockPos pos, Holder<Biome> biome, int layers) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (sereneseasons) {
            return SereneSeasonsCompat.shouldMelt(level, pos, biome);
        }
        if (CommonProxy.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.m_46472_(), biome) && ((Biome)biome.m_203334_()).m_198906_(pos) && CommonProxy.skyLightEnoughToMelt(level, pos, layers)) {
            return true;
        }
        if (layers <= 1) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9) {
                return false;
            }
            if (!(level.m_8055_(pos.m_7495_()).m_60734_() instanceof SnowLayerBlock)) {
                return false;
            }
        }
        return SnowCommonConfig.snowNaturalMelt && CommonProxy.skyLightEnoughToMelt(level, pos, layers);
    }

    public static boolean snowAndIceMeltInWarmBiomes(ResourceKey<Level> dimension, Holder<Biome> biome) {
        if (SnowCommonConfig.snowAndIceMeltInWarmBiomes) {
            return true;
        }
        if (sereneseasons) {
            return SereneSeasonsCompat.snowAndIceMeltInWarmBiomes(dimension, biome);
        }
        return false;
    }

    public static boolean skyLightEnoughToMelt(Level level, BlockPos pos, int layers) {
        return level.m_45517_(LightLayer.SKY, layers == 8 ? pos.m_7494_() : pos) > 2;
    }

    public static boolean blockLightEnoughToMelt(Level level, BlockPos pos) {
        return level.m_45517_(LightLayer.BLOCK, pos) > SnowCommonConfig.snowPersistMaxLightLevel;
    }

    public static boolean shouldMeltInGeneral(Level level, BlockPos pos, int layers) {
        return CommonProxy.shouldMeltByTemperature(level, pos, (Holder<Biome>)level.m_204166_(pos), layers) || CommonProxy.blockLightEnoughToMelt(level, pos);
    }

    public static boolean shouldMeltInGeneral(Level level, BlockPos pos) {
        return CommonProxy.shouldMeltInGeneral(level, pos, 1);
    }

    public static boolean coldEnoughToSnow(LevelReader level, BlockPos pos, Holder<Biome> biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return ((Biome)biome.m_203334_()).m_198904_(pos);
    }

    public static boolean isWinter(Level level, BlockPos pos, Holder<Biome> biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.isWinter(level, pos, biome);
        }
        return false;
    }
}

