/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.block.ColumnBlock;
import com.starfish_studios.bbb.registry.BBBTags;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StoneFenceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    public static final BooleanProperty SIDE_FILL = BooleanProperty.m_61465_((String)"side_fill");
    public static final BooleanProperty PILLAR = BooleanProperty.m_61465_((String)"pillar");
    public VoxelShape PILLAR_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public VoxelShape NORTH_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
    public VoxelShape EAST_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public VoxelShape SOUTH_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
    public VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
    public VoxelShape PILLAR_COLLISION = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    public VoxelShape NORTH_COLLISION = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)4.0);
    public VoxelShape EAST_COLLISION = Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)24.0, (double)12.0);
    public VoxelShape SOUTH_COLLISION = Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)24.0, (double)16.0);
    public VoxelShape WEST_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)24.0, (double)12.0);

    public StoneFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SIDE_FILL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PILLAR, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shape = this.PILLAR_AABB;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.NORTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.EAST_AABB);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.SOUTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.WEST_AABB);
        }
        return shape;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shape = this.PILLAR_COLLISION;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.NORTH_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.EAST_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.SOUTH_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.WEST_COLLISION);
        }
        return shape;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType path) {
        return false;
    }

    public boolean connectsTo(BlockState state, boolean bl, Direction direction) {
        Block block = state.m_60734_();
        boolean bl2 = this.isSameFence(state);
        boolean bl3 = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return !StoneFenceBlock.isExceptionForConnection(state) && bl || bl2 || bl3;
    }

    public static boolean isExceptionForConnection(BlockState state) {
        return state.m_60734_() instanceof LeavesBlock || state.m_60713_(Blocks.f_50375_) || state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_) || state.m_60713_(Blocks.f_50186_) || state.m_60713_(Blocks.f_50133_) || state.m_204336_(BlockTags.f_13083_) || state.m_60734_() instanceof ColumnBlock;
    }

    private boolean isSameFence(BlockState state) {
        return state.m_204336_(BBBTags.BBBBlockTags.STONE_FENCES) || state.m_204336_(BlockTags.f_13032_);
    }

    private static boolean anyNS(BlockState state) {
        return (Boolean)state.m_61143_((Property)NORTH) != false || (Boolean)state.m_61143_((Property)SOUTH) != false;
    }

    private static boolean anyEW(BlockState state) {
        return (Boolean)state.m_61143_((Property)EAST) != false || (Boolean)state.m_61143_((Property)WEST) != false;
    }

    private static boolean isCorner(BlockState state) {
        return StoneFenceBlock.anyNS(state) && StoneFenceBlock.anyEW(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level;
        FluidState fluid;
        BlockState state = (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf((fluid = (level = context.m_43725_()).m_6425_(pos = context.m_8083_())).m_76152_() == Fluids.f_76193_));
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            Direction direction = entry.getKey();
            BooleanProperty prop = entry.getValue();
            BlockState neighbor = level.m_8055_(pos.m_121945_(direction));
            boolean connects = this.connectsTo(neighbor, neighbor.m_60783_((BlockGetter)level, pos.m_121945_(direction), direction.m_122424_()), direction.m_122424_());
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(connects));
        }
        if (StoneFenceBlock.isCorner(state)) {
            state = (BlockState)state.m_61124_((Property)PILLAR, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        boolean connects;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!direction.m_122434_().m_122479_()) {
            return super.m_7417_(state, direction, neighbor, level, pos, neighborPos);
        }
        BooleanProperty prop = PROPERTY_BY_DIRECTION.get(direction);
        BlockState corner = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(connects = this.connectsTo(neighbor, neighbor.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_()), direction.m_122424_())));
        if (StoneFenceBlock.isCorner(corner)) {
            return (BlockState)corner.m_61124_((Property)PILLAR, (Comparable)Boolean.valueOf(true));
        }
        if (!StoneFenceBlock.anyNS(corner) && !StoneFenceBlock.anyEW(corner)) {
            BlockState updated = corner;
            if (!((Boolean)updated.m_61143_((Property)PILLAR)).booleanValue()) {
                updated = (BlockState)updated.m_61124_((Property)PILLAR, (Comparable)Boolean.valueOf(true));
            }
            updated = (BlockState)updated.m_61124_((Property)SIDE_FILL, (Comparable)Boolean.valueOf(false));
            return updated;
        }
        return corner;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED, SIDE_FILL, PILLAR});
    }
}

