/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.registry.BBBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LayerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)1, (int)4);
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape LAYER_1_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape LAYER_2_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape LAYER_3_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape LAYER_4_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_1_DOWN = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_2_DOWN = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_3_DOWN = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_4_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_1_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_2_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_3_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_4_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_1_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    public static final VoxelShape LAYER_2_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape LAYER_3_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape LAYER_4_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_1_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_2_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_3_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_4_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_1_WEST = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_2_WEST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_3_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LAYER_4_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public LayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_21120_(hand).m_204117_(BBBTags.BBBItemTags.HAMMERS)) {
            if ((Integer)state.m_61143_((Property)LAYERS) > 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LAYERS) - 1)), 3);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_5456_().m_7968_());
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                level.m_5594_(player, pos, level.m_8055_(pos).m_60734_().m_49962_(level.m_8055_(pos)).m_56775_(), player.m_5720_(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if ((Integer)state.m_61143_((Property)LAYERS) == 1) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_5456_().m_7968_());
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                level.m_5594_(player, pos, level.m_8055_(pos).m_60734_().m_49962_(level.m_8055_(pos)).m_56775_(), player.m_5720_(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)LAYERS)) {
            case 1 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield LAYER_1_NORTH;
                    }
                    case SOUTH: {
                        yield LAYER_1_SOUTH;
                    }
                    case EAST: {
                        yield LAYER_1_EAST;
                    }
                    case WEST: {
                        yield LAYER_1_WEST;
                    }
                    case UP: {
                        yield LAYER_1_UP;
                    }
                    case DOWN: 
                }
                yield LAYER_1_DOWN;
            }
            case 2 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield LAYER_2_NORTH;
                    }
                    case SOUTH: {
                        yield LAYER_2_SOUTH;
                    }
                    case EAST: {
                        yield LAYER_2_EAST;
                    }
                    case WEST: {
                        yield LAYER_2_WEST;
                    }
                    case UP: {
                        yield LAYER_2_UP;
                    }
                    case DOWN: 
                }
                yield LAYER_2_DOWN;
            }
            case 3 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield LAYER_3_NORTH;
                    }
                    case SOUTH: {
                        yield LAYER_3_SOUTH;
                    }
                    case EAST: {
                        yield LAYER_3_EAST;
                    }
                    case WEST: {
                        yield LAYER_3_WEST;
                    }
                    case UP: {
                        yield LAYER_3_UP;
                    }
                    case DOWN: 
                }
                yield LAYER_3_DOWN;
            }
            case 4 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield LAYER_4_NORTH;
                    }
                    case SOUTH: {
                        yield LAYER_4_SOUTH;
                    }
                    case EAST: {
                        yield LAYER_4_EAST;
                    }
                    case WEST: {
                        yield LAYER_4_WEST;
                    }
                    case UP: {
                        yield LAYER_4_UP;
                    }
                    case DOWN: 
                }
                yield LAYER_4_DOWN;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(state.m_61143_((Property)LAYERS)));
        };
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (state.m_61143_((Property)FACING) != context.m_43719_()) {
            return false;
        }
        return context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)LAYERS) < 4 || super.m_6864_(state, context);
    }

    private static boolean isFull(BlockState state) {
        return (Integer)state.m_61143_((Property)LAYERS) == 4;
    }

    private static BlockState removeWaterIfFull(BlockState state) {
        return LayerBlock.isFull(state) ? (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        FluidState fluid = ctx.m_43725_().m_6425_(pos);
        BlockState existing = ctx.m_43725_().m_8055_(pos);
        if (existing.m_60713_((Block)this)) {
            BlockState stacked = (BlockState)existing.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(4, (Integer)existing.m_61143_((Property)LAYERS) + 1)));
            return LayerBlock.removeWaterIfFull(stacked);
        }
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
            int n = 0;
            Direction[] lookDirs = ctx.m_6232_();
            Direction[] directionArray = lookDirs;
            int n2 = directionArray.length;
            if (n < n2) {
                Direction d = directionArray[n];
                BlockState placed = d.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_151260_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)d.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
                return LayerBlock.removeWaterIfFull(placed);
            }
            BlockState placed = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
            return LayerBlock.removeWaterIfFull(placed);
        }
        BlockState base = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        Direction face = ctx.m_43719_();
        if (face == Direction.DOWN || face != Direction.UP && ctx.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5) {
            base = (BlockState)base.m_61124_((Property)FACING, (Comparable)Direction.DOWN);
        }
        return LayerBlock.removeWaterIfFull(base);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState state, @NotNull FluidState fluidState) {
        return (Integer)state.m_61143_((Property)LAYERS) != 4 && super.m_7361_(level, pos, state, fluidState);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_6044_(@NotNull BlockGetter level, @NotNull BlockPos pos, BlockState state, @NotNull Fluid fluid) {
        return (Integer)state.m_61143_((Property)LAYERS) != 4 && super.m_6044_(level, pos, state, fluid);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState state2, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos pos2) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, state2, level, pos, pos2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, LAYERS});
    }
}

