/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.google.common.collect.Maps;
import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.LatticePlantType;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LatticeBlock
extends Block
implements SimpleWaterloggedBlock,
BonemealableBlock,
CaveVines {
    public static DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static EnumProperty<LatticePlantType> PLANT_TYPE = BBBBlockStateProperties.PLANT_TYPE;
    public static BooleanProperty LEFT = BBBBlockStateProperties.LEFT;
    public static BooleanProperty MIDDLE = BBBBlockStateProperties.MIDDLE;
    public static BooleanProperty RIGHT = BBBBlockStateProperties.RIGHT;
    public static VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static VoxelShape NORTH_PLANT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)14.0);
    public static VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static VoxelShape SOUTH_PLANT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)3.0);
    public static VoxelShape WEST_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static VoxelShape WEST_PLANT_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    public static VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static VoxelShape EAST_PLANT_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final Map<LatticePlantType, Item> PLANT_TYPE_TO_ITEM = (Map)Util.m_137469_((Object)Maps.newEnumMap(LatticePlantType.class), map -> {
        map.put(LatticePlantType.NONE, null);
        map.put(LatticePlantType.VINES, Items.f_42029_);
        map.put(LatticePlantType.OAK_LEAVES, Items.f_41896_);
        map.put(LatticePlantType.SPRUCE_LEAVES, Items.f_41897_);
        map.put(LatticePlantType.BIRCH_LEAVES, Items.f_41898_);
        map.put(LatticePlantType.JUNGLE_LEAVES, Items.f_41899_);
        map.put(LatticePlantType.ACACIA_LEAVES, Items.f_41900_);
        map.put(LatticePlantType.DARK_OAK_LEAVES, Items.f_41901_);
        map.put(LatticePlantType.AZALEA_LEAVES, Items.f_151009_);
        map.put(LatticePlantType.FLOWERING_AZALEA_LEAVES, Items.f_186362_);
        map.put(LatticePlantType.MANGROVE_LEAVES, Items.f_220178_);
        map.put(LatticePlantType.CHERRY_LEAVES, Items.f_271517_);
        map.put(LatticePlantType.GLOW_LICHEN, Items.f_151025_);
        map.put(LatticePlantType.CAVE_VINES, Items.f_151079_);
    });

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)MIDDLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(true))).m_61124_(PLANT_TYPE, (Comparable)((Object)LatticePlantType.NONE))).m_61124_((Property)f_152949_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        LatticePlantType plantType = (LatticePlantType)((Object)state.m_61143_(PLANT_TYPE));
        VoxelShape shape = Shapes.m_83040_();
        if (direction == Direction.NORTH) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_AABB);
            if (plantType != LatticePlantType.NONE) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_PLANT_AABB);
            }
        } else if (direction == Direction.SOUTH) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_AABB);
            if (plantType != LatticePlantType.NONE) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_PLANT_AABB);
            }
        } else if (direction == Direction.WEST) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_AABB);
            if (plantType != LatticePlantType.NONE) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_PLANT_AABB);
            }
        } else if (direction == Direction.EAST) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_AABB);
            if (plantType != LatticePlantType.NONE) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_PLANT_AABB);
            }
        }
        return shape;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        LatticePlantType plantType = (LatticePlantType)((Object)state.m_61143_(PLANT_TYPE));
        VoxelShape shape = Shapes.m_83040_();
        if (direction == Direction.NORTH && plantType != LatticePlantType.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_PLANT_AABB);
        } else if (direction == Direction.SOUTH && plantType != LatticePlantType.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_PLANT_AABB);
        } else if (direction == Direction.EAST && plantType != LatticePlantType.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_PLANT_AABB);
        } else if (direction == Direction.WEST && plantType != LatticePlantType.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_PLANT_AABB);
        }
        return shape;
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean n = this.validConnection(level.m_8055_(pos.m_122012_()), (BlockGetter)level, pos.m_122012_());
        boolean e = this.validConnection(level.m_8055_(pos.m_122029_()), (BlockGetter)level, pos.m_122029_());
        boolean s = this.validConnection(level.m_8055_(pos.m_122019_()), (BlockGetter)level, pos.m_122019_());
        boolean w = this.validConnection(level.m_8055_(pos.m_122024_()), (BlockGetter)level, pos.m_122024_());
        boolean t = this.validConnection(level.m_8055_(pos.m_7494_()), (BlockGetter)level, pos.m_7494_());
        boolean b = this.validConnection(level.m_8055_(pos.m_7495_()), (BlockGetter)level, pos.m_7495_());
        if (state.m_61143_((Property)FACING) == Direction.NORTH) {
            boolean left = !e || !this.validConnection(level.m_8055_(pos.m_122029_()), (BlockGetter)level, pos.m_122029_());
            boolean right = !w || !this.validConnection(level.m_8055_(pos.m_122024_()), (BlockGetter)level, pos.m_122024_());
            return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
            boolean left = !w || !this.validConnection(level.m_8055_(pos.m_122024_()), (BlockGetter)level, pos.m_122024_());
            boolean right = !e || !this.validConnection(level.m_8055_(pos.m_122029_()), (BlockGetter)level, pos.m_122029_());
            return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST) {
            boolean left = !s || !this.validConnection(level.m_8055_(pos.m_122019_()), (BlockGetter)level, pos.m_122019_());
            boolean right = !n || !this.validConnection(level.m_8055_(pos.m_122012_()), (BlockGetter)level, pos.m_122012_());
            return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
        }
        if (state.m_61143_((Property)FACING) == Direction.WEST) {
            boolean left = !n || !this.validConnection(level.m_8055_(pos.m_122012_()), (BlockGetter)level, pos.m_122012_());
            boolean right = !s || !this.validConnection(level.m_8055_(pos.m_122019_()), (BlockGetter)level, pos.m_122019_());
            return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
        }
        return state;
    }

    public boolean validConnection(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_60783_(getter, pos, Direction.UP) || state.m_60783_(getter, pos, Direction.DOWN) || state.m_60783_(getter, pos, Direction.NORTH) || state.m_60783_(getter, pos, Direction.EAST) || state.m_60783_(getter, pos, Direction.SOUTH) || state.m_60783_(getter, pos, Direction.WEST) || state.m_60713_((Block)this);
    }

    public void m_6256_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        Item item;
        LatticePlantType plantType;
        if (!level.f_46443_ && player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42574_) && PLANT_TYPE_TO_ITEM.containsKey((Object)(plantType = (LatticePlantType)((Object)blockState.m_61143_(PLANT_TYPE)))) && (item = PLANT_TYPE_TO_ITEM.get((Object)plantType)) != null) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(PLANT_TYPE, (Comparable)((Object)LatticePlantType.NONE)), 3);
            LatticeBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)item));
            level.m_5594_(null, blockPos, SoundEvents.f_144238_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static InteractionResult use(@Nullable Entity entity, BlockState blockState, Level level, BlockPos blockPos) {
        return InteractionResult.PASS;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack;
        if (!level.f_46443_ && player.m_21120_(hand).m_150930_(Items.f_42574_)) {
            Item item;
            LatticePlantType plantType = (LatticePlantType)((Object)state.m_61143_(PLANT_TYPE));
            if (((Boolean)state.m_61143_((Property)f_152949_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_(PLANT_TYPE, (Comparable)((Object)LatticePlantType.NONE)), 3);
                return CaveVines.m_269473_(null, (BlockState)state, (Level)level, (BlockPos)pos);
            }
            if (PLANT_TYPE_TO_ITEM.containsKey((Object)plantType) && (item = PLANT_TYPE_TO_ITEM.get((Object)plantType)) != null) {
                level.m_7731_(pos, (BlockState)state.m_61124_(PLANT_TYPE, (Comparable)((Object)LatticePlantType.NONE)), 3);
                LatticeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)item));
                level.m_5594_(null, pos, SoundEvents.f_144238_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (state.m_61143_(PLANT_TYPE) == LatticePlantType.NONE && PLANT_TYPE_TO_ITEM.containsValue((itemStack = player.m_21120_(hand)).m_41720_())) {
            for (Map.Entry<LatticePlantType, Item> entry : PLANT_TYPE_TO_ITEM.entrySet()) {
                if (entry.getValue() != itemStack.m_41720_()) continue;
                level.m_7731_(pos, (BlockState)state.m_61124_(PLANT_TYPE, (Comparable)((Object)entry.getKey())), 3);
                level.m_5594_(null, pos, entry.getKey() == LatticePlantType.VINES ? SoundEvents.f_144241_ : SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return CaveVines.m_269473_(null, (BlockState)state, (Level)level, (BlockPos)pos);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return (Boolean)blockState.m_61143_((Property)f_152949_) == false && blockState.m_61143_(PLANT_TYPE) == LatticePlantType.CAVE_VINES;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)f_152949_, (Comparable)Boolean.valueOf(true)), 2);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_192917_((Fluid)Fluids.f_76193_)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, LEFT, RIGHT, MIDDLE, PLANT_TYPE, f_152949_});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

