/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.google.common.collect.Maps;
import com.starfish_studios.bbb.BBBConfig;
import com.starfish_studios.bbb.block.LayerBlock;
import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.FrameStickDirection;
import com.starfish_studios.bbb.registry.BBBTags;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FrameBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty CORNERS = BooleanProperty.m_61465_((String)"corners");
    public static final EnumProperty<FrameStickDirection> FRAME_CENTER = BBBBlockStateProperties.FRAME_CENTER;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TOP = BBBBlockStateProperties.TOP;
    public static final BooleanProperty BOTTOM = BBBBlockStateProperties.BOTTOM;
    public static final BooleanProperty LEFT = BBBBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = BBBBlockStateProperties.RIGHT;
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape WEST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_CENTER = Block.m_49796_((double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_CENTER = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0);
    private static final VoxelShape SOUTH_CENTER = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0);
    private static final VoxelShape WEST_CENTER = Block.m_49796_((double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape FALLBACK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape[] NORTH_SIDES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)-1.0, (double)13.0, (double)16.0, (double)0.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] EAST_SIDES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)3.0, (double)0.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0)};
    private static final VoxelShape[] SOUTH_SIDES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0)};
    private static final VoxelShape[] WEST_SIDES = new VoxelShape[]{Block.m_49796_((double)13.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final Map<Direction, VoxelShape> FULL_SHAPES = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), m -> {
        m.put(Direction.NORTH, NORTH);
        m.put(Direction.EAST, EAST);
        m.put(Direction.SOUTH, SOUTH);
        m.put(Direction.WEST, WEST);
    });
    private static final Map<Direction, VoxelShape> CENTER_SHAPES = Map.of(Direction.NORTH, NORTH_CENTER, Direction.EAST, EAST_CENTER, Direction.SOUTH, SOUTH_CENTER, Direction.WEST, WEST_CENTER);
    private static final Map<Direction, VoxelShape[]> SIDE_SHAPES = Map.of(Direction.NORTH, NORTH_SIDES, Direction.EAST, EAST_SIDES, Direction.SOUTH, SOUTH_SIDES, Direction.WEST, WEST_SIDES);
    private static final int TOP_INDEX = 0;
    private static final int BOTTOM_INDEX = 1;
    private static final int LEFT_INDEX = 2;
    private static final int RIGHT_INDEX = 3;

    public FrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CORNERS, (Comparable)Boolean.valueOf(true))).m_61124_(FRAME_CENTER, (Comparable)((Object)FrameStickDirection.NONE)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_21120_(hand).m_204117_(BBBTags.BBBItemTags.HAMMERS)) {
            FrameStickDirection[] cycle = new FrameStickDirection[]{FrameStickDirection.LEFT, FrameStickDirection.VERTICAL, FrameStickDirection.RIGHT, FrameStickDirection.HORIZONTAL};
            FrameStickDirection current = (FrameStickDirection)((Object)state.m_61143_(FRAME_CENTER));
            int index = Arrays.asList(cycle).indexOf((Object)current);
            FrameStickDirection next = cycle[(index + 1) % cycle.length];
            BlockState updated = (BlockState)state.m_61124_(FRAME_CENTER, (Comparable)((Object)next));
            level.m_7731_(pos, updated, 3);
            if (state.m_204336_(BBBTags.BBBBlockTags.WOODEN_FRAMES)) {
                level.m_5594_(player, pos, Blocks.f_50616_.m_49966_().m_60827_().m_56777_(), player.m_5720_(), 1.0f, 1.0f);
            } else if (state.m_204336_(BBBTags.BBBBlockTags.STONE_FRAMES)) {
                level.m_5594_(player, pos, Blocks.f_50069_.m_49966_().m_60827_().m_56777_(), player.m_5720_(), 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        if (state.m_61143_(FRAME_CENTER) != FrameStickDirection.NONE) {
            BlockState reset = (BlockState)state.m_61124_(FRAME_CENTER, (Comparable)((Object)FrameStickDirection.NONE));
            level.m_7731_(pos, reset, 3);
        }
    }

    private boolean showsFullOutline(CollisionContext context, BlockState state) {
        EntityCollisionContext ec;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ec = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            return player.m_21093_(s -> s.m_204117_(BBBTags.BBBItemTags.FRAMES) || s.m_204117_(BBBTags.BBBItemTags.HAMMERS)) || player.m_6144_() && !BBBConfig.disableFrameCrouchHitbox || BBBConfig.alwaysShowFrameHitboxes;
        }
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (this.showsFullOutline(context, state)) {
            return FULL_SHAPES.get(state.m_61143_((Property)FACING));
        }
        VoxelShape shape = this.buildShape(state);
        if (shape.m_83281_() && context == CollisionContext.m_82749_()) {
            return FALLBACK;
        }
        return shape;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.buildShape(state);
    }

    private VoxelShape buildShape(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = state.m_61143_(FRAME_CENTER) != FrameStickDirection.NONE ? CENTER_SHAPES.get(facing) : Shapes.m_83040_();
        VoxelShape[] parts = SIDE_SHAPES.get(facing);
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)parts[0]);
        }
        if (((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)parts[1]);
        }
        if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)parts[2]);
        }
        if (((Boolean)state.m_61143_((Property)RIGHT)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)parts[3]);
        }
        return shape;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnectedState(state, level, pos);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, TOP, BOTTOM, LEFT, RIGHT, CORNERS, FRAME_CENTER});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return type == PathComputationType.LAND && (Boolean)state.m_61143_((Property)TOP) == false && (Boolean)state.m_61143_((Property)BOTTOM) == false && (Boolean)state.m_61143_((Property)LEFT) == false && (Boolean)state.m_61143_((Property)RIGHT) == false;
    }

    private BlockState getConnectedState(BlockState state, LevelAccessor level, BlockPos pos) {
        EnumMap<Direction, Boolean> connections = new EnumMap<Direction, Boolean>(Direction.class);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            boolean canConnect = neighborState.m_60734_() instanceof FrameBlock ? neighborState.m_61143_((Property)FACING) == facing : this.validConnection(neighborState, (BlockGetter)level, neighborPos, direction);
            connections.put(direction, canConnect);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf((Boolean)connections.get(Direction.UP) == false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf((Boolean)connections.get(Direction.DOWN) == false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf((Boolean)connections.get(facing.m_122427_()) == false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf((Boolean)connections.get(facing.m_122428_()) == false));
    }

    public boolean validConnection(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        if (state.m_60734_() instanceof LayerBlock) {
            Direction layerFacing = (Direction)state.m_61143_((Property)LayerBlock.FACING);
            return layerFacing == direction;
        }
        if (state.m_60734_() instanceof SlabBlock) {
            SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            if (type == SlabType.BOTTOM && direction == Direction.UP) {
                return true;
            }
            return type == SlabType.TOP && direction == Direction.DOWN;
        }
        if (state.m_204336_(BBBTags.BBBBlockTags.FRAMES)) {
            return true;
        }
        return state.m_60804_(getter, pos);
    }
}

