/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.util.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.voidarkana.fintastic.Fintastic;

public class MultipartEntityMessage {
    public int parentId;
    public int playerId;
    public int type;
    public double damage;

    public MultipartEntityMessage(int parentId, int playerId, int type, double damage) {
        this.parentId = parentId;
        this.playerId = playerId;
        this.type = type;
        this.damage = damage;
    }

    public MultipartEntityMessage() {
    }

    public static MultipartEntityMessage read(FriendlyByteBuf buf) {
        return new MultipartEntityMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readDouble());
    }

    public static void write(MultipartEntityMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.parentId);
        buf.writeInt(message.playerId);
        buf.writeInt(message.type);
        buf.writeDouble(message.damage);
    }

    public static void handle(MultipartEntityMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer playerSided = ((NetworkEvent.Context)context.get()).getSender();
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                playerSided = Fintastic.PROXY.getClientSidePlayer();
            }
            Entity parent = playerSided.m_9236_().m_6815_(message.parentId);
            Entity interacter = playerSided.m_9236_().m_6815_(message.playerId);
            if (interacter != null && parent != null && parent.isMultipartEntity() && interacter.m_20270_(parent) < 16.0f) {
                if (message.type == 0) {
                    if (interacter instanceof Player) {
                        Player player = (Player)interacter;
                        parent.m_6096_(player, player.m_7655_());
                    }
                } else if (message.type == 1) {
                    parent.m_6469_(parent.m_269291_().m_269264_(), (float)message.damage);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

