/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom.base;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;

public abstract class VariantBoidingFish
extends BucketableFishEntity {
    private static final EntityDataAccessor<Integer> MODEL_VARIANT = SynchedEntityData.m_135353_(VariantBoidingFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN_VARIANT = SynchedEntityData.m_135353_(VariantBoidingFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public VariantBoidingFish leader;
    private int schoolSize = 1;

    protected VariantBoidingFish(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SKIN_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("VariantModel", this.getVariantModel());
        compound.m_128405_("VariantSkin", this.getVariantSkin());
    }

    public int getVariantModel() {
        return (Integer)this.f_19804_.m_135370_(MODEL_VARIANT);
    }

    public void setVariantModel(int variant) {
        this.f_19804_.m_135381_(MODEL_VARIANT, (Object)variant);
    }

    public int getVariantSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN_VARIANT);
    }

    public void setVariantSkin(int variant) {
        this.f_19804_.m_135381_(SKIN_VARIANT, (Object)variant);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariantModel(compound.m_128451_("VariantModel"));
        this.setVariantSkin(compound.m_128451_("VariantSkin"));
    }

    public abstract ItemStack m_28282_();

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pSpawnData == null) {
            pSpawnData = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)pSpawnData).leader);
        }
        return pSpawnData;
    }

    @Override
    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return 10;
    }

    @Override
    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        if (this.canBabiesSchoolWithAdults()) {
            return this.leader != null && this.leader.m_6084_() && this.leader.getVariantModel() == this.getVariantModel() && this.leader.getVariantSkin() == this.getVariantSkin();
        }
        return this.leader != null && this.leader.m_6084_() && this.leader.getVariantModel() == this.getVariantModel() && this.leader.getVariantSkin() == this.getVariantSkin() && this.leader.m_6162_() == this.m_6162_();
    }

    public VariantBoidingFish startFollowing(VariantBoidingFish pLeader) {
        this.leader = pLeader;
        pLeader.addFollower();
        return pLeader;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        if (this.m_6162_() && this.canBabiesSchoolWithAdults()) {
            return false;
        }
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.2);
        }
    }

    public void addFollowers(Stream<? extends VariantBoidingFish> pFollowers) {
        pFollowers.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p_27538_ -> p_27538_ != this).forEach(fish -> {
            if (this.getVariantSkin() == fish.getVariantSkin() && this.getVariantModel() == fish.getVariantModel()) {
                if (this.canBabiesSchoolWithAdults()) {
                    fish.startFollowing(this);
                } else if (this.m_6162_() == fish.m_6162_()) {
                    fish.startFollowing(this);
                }
            }
        });
    }

    public boolean canBabiesSchoolWithAdults() {
        return true;
    }

    public static class SchoolSpawnGroupData
    extends BreedableWaterAnimal.AgeableFishGroupData {
        public final VariantBoidingFish leader;

        public SchoolSpawnGroupData(VariantBoidingFish pLeader) {
            super(true);
            this.leader = pLeader;
        }
    }
}

