/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom.base;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;

public abstract class AbstractSwimmingBottomDweller
extends BucketableFishEntity {
    public int swimmingTicks = 0;
    public int prevSwimTick = 0;
    private static final EntityDataAccessor<Boolean> WANTS_TO_SWIM = SynchedEntityData.m_135353_(AbstractSwimmingBottomDweller.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AbstractSwimmingBottomDweller(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.f_21343_ = new FishJumpControl(this);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1, 1, 0.02f, 0.1f, true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WANTS_TO_SWIM, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("WantsToSwim", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("WantsToSwim"));
    }

    public boolean getWantsToSwim() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_SWIM);
    }

    public void setWantsToSwim(boolean pFromBucket) {
        this.f_19804_.m_135381_(WANTS_TO_SWIM, (Object)pFromBucket);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_() && this.m_20069_() && this.f_19796_.m_188503_(1000) == 0 && !this.getWantsToSwim()) {
            this.setWantsToSwim(true);
        }
        if (this.m_20069_() && !this.m_20096_() && (this.f_19796_.m_188503_(1000) == 0 || this.swimmingTicks == 2400) && this.getWantsToSwim()) {
            this.setWantsToSwim(false);
            this.swimmingTicks = 0;
            this.prevSwimTick = 0;
        }
        if (this.getWantsToSwim()) {
            this.prevSwimTick = this.swimmingTicks;
            this.swimmingTicks = this.prevSwimTick + 1;
        }
        if (!this.m_9236_().f_46443_) {
            // empty if block
        }
    }

    @Override
    public void m_8107_() {
        if (this.m_20069_()) {
            BlockPos pos = this.m_20183_();
            BlockState block = this.m_9236_().m_8055_(pos.m_7494_());
            if (this.getStepHeight() >= 1.0f && block.m_60819_().m_192917_(Fluids.f_76191_)) {
                this.m_274367_(0.0f);
            } else if (this.m_20069_() && block.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                this.m_274367_(1.0f);
            }
        }
        super.m_8107_();
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && !this.getWantsToSwim() && this.m_5448_() == null) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.025, 0.0));
        }
        if (this.m_21515_() && this.m_20069_() && this.getWantsToSwim() && this.m_5448_() == null && this.f_19796_.m_188503_(500) == 0) {
            this.setWantsToSwim(false);
        }
        super.m_7023_(pTravelVector);
    }

    protected void m_6475_(DamageSource pDamageSource, float pDamageAmount) {
        if (this.swimmingTicks > 0) {
            this.swimmingTicks = 0;
        }
        if (!this.getWantsToSwim()) {
            this.setWantsToSwim(true);
        }
        super.m_6475_(pDamageSource, pDamageAmount);
    }

    static class FishJumpControl
    extends JumpControl {
        AbstractSwimmingBottomDweller mob;

        public FishJumpControl(AbstractSwimmingBottomDweller fish) {
            super((Mob)fish);
            this.mob = fish;
        }

        public void m_24901_() {
            if (!this.mob.m_20069_()) {
                super.m_24901_();
            }
        }
    }
}

