/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;
import net.voidarkana.fintastic.common.entity.custom.base.VariantSchoolingFish;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;

public class MinnowEntity
extends VariantSchoolingFish {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();
    public final AnimationState swimAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);

    public MinnowEntity(EntityType<? extends BucketableFishEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.6f);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariantModel(compound.m_128451_("VariantModel"));
        this.setVariantSkin(compound.m_128451_("VariantSkin"));
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        compoundnbt.m_128405_("VariantModel", this.getVariantModel());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
        this.swimAnimationState.m_246184_(this.f_267362_.m_267780_() && this.m_20072_(), this.f_19797_);
        this.flopAnimationState.m_246184_(!this.m_20072_(), this.f_19797_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        }
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("VariantModel", 3)) {
            this.setVariantModel(pDataTag.m_128451_("VariantModel"));
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else if (pReason == MobSpawnType.SPAWN_EGG || pReason == MobSpawnType.BUCKET && pDataTag == null) {
            MinnowVariant variant = (MinnowVariant)((Object)Util.m_214670_((Object[])MinnowVariant.values(), (RandomSource)this.f_19796_));
            this.setVariantModel(variant.getModel());
            this.setVariantSkin(variant.getSkin());
        } else {
            int skin;
            int model;
            if (pSpawnData instanceof MinnowGroupData) {
                MinnowGroupData groupData = (MinnowGroupData)pSpawnData;
                model = groupData.getVariantModel();
                skin = groupData.getVariantSkin();
                this.startFollowing(groupData.leader);
            } else {
                if (this.m_20183_().m_123342_() <= pLevel.m_5736_() - 33 && pLevel.m_8055_(this.m_20183_()).m_60713_(Blocks.f_49990_)) {
                    if (this.m_217043_().m_188499_()) {
                        model = MinnowVariant.MEXICAN_CAVE_TETRA.getModel();
                        skin = MinnowVariant.MEXICAN_CAVE_TETRA.getSkin();
                    } else {
                        model = MinnowVariant.SOUTHERN_CAVE_FISH.getModel();
                        skin = MinnowVariant.SOUTHERN_CAVE_FISH.getSkin();
                    }
                } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_SWAMP)) {
                    int var = this.m_217043_().m_188503_(16);
                    model = switch (var) {
                        case 1 -> MinnowVariant.NEON_GREEN_RASBORA.getModel();
                        case 2 -> MinnowVariant.CHILI_RASBORA.getModel();
                        case 3 -> MinnowVariant.NEON_TETRA.getModel();
                        case 4 -> MinnowVariant.CARDINAL_TETRA.getModel();
                        case 5 -> MinnowVariant.DRAGONFIN_TETRA.getModel();
                        case 6 -> MinnowVariant.MARBLED_HATCHETFISH.getModel();
                        case 7 -> MinnowVariant.SILVER_HATCHETFISH.getModel();
                        case 8 -> MinnowVariant.COPELLA_TETRA.getModel();
                        case 9 -> MinnowVariant.PIABUCO.getModel();
                        case 10 -> MinnowVariant.GIANT_DANIO.getModel();
                        case 11 -> MinnowVariant.BUENOS_AIRES_TETRA.getModel();
                        case 12 -> MinnowVariant.RED_TAIL_ASTYANAX.getModel();
                        case 13 -> MinnowVariant.MASKED_BARB.getModel();
                        case 14 -> MinnowVariant.BANDED_ASTYANAX.getModel();
                        case 15 -> MinnowVariant.STREAKED_PROCHILODUS.getModel();
                        default -> MinnowVariant.FLAGTAIL_PROCHILODUS.getModel();
                    };
                    skin = switch (var) {
                        case 1 -> MinnowVariant.NEON_GREEN_RASBORA.getSkin();
                        case 2 -> MinnowVariant.CHILI_RASBORA.getSkin();
                        case 3 -> MinnowVariant.NEON_TETRA.getSkin();
                        case 4 -> MinnowVariant.CARDINAL_TETRA.getSkin();
                        case 5 -> MinnowVariant.DRAGONFIN_TETRA.getSkin();
                        case 6 -> MinnowVariant.MARBLED_HATCHETFISH.getSkin();
                        case 7 -> MinnowVariant.SILVER_HATCHETFISH.getSkin();
                        case 8 -> MinnowVariant.COPELLA_TETRA.getSkin();
                        case 9 -> MinnowVariant.PIABUCO.getSkin();
                        case 10 -> MinnowVariant.GIANT_DANIO.getSkin();
                        case 11 -> MinnowVariant.BUENOS_AIRES_TETRA.getSkin();
                        case 12 -> MinnowVariant.RED_TAIL_ASTYANAX.getSkin();
                        case 13 -> MinnowVariant.MASKED_BARB.getSkin();
                        case 14 -> MinnowVariant.BANDED_ASTYANAX.getSkin();
                        case 15 -> MinnowVariant.STREAKED_PROCHILODUS.getSkin();
                        default -> MinnowVariant.FLAGTAIL_PROCHILODUS.getSkin();
                    };
                } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207610_)) {
                    int var = this.m_217043_().m_188503_(21);
                    model = switch (var) {
                        case 1 -> MinnowVariant.FLAGTAIL_PROCHILODUS.getModel();
                        case 2 -> MinnowVariant.COPELLA_TETRA.getModel();
                        case 3 -> MinnowVariant.PIABUCO.getModel();
                        case 4 -> MinnowVariant.HARLEQUIN_RASBORA.getModel();
                        case 5 -> MinnowVariant.ODESSA_BARB.getModel();
                        case 6 -> MinnowVariant.RUBY_BARB.getModel();
                        case 7 -> MinnowVariant.BANDED_ASTYANAX.getModel();
                        case 8 -> MinnowVariant.TETRAZONA_BARB.getModel();
                        case 9 -> MinnowVariant.MASKED_BARB.getModel();
                        case 10 -> MinnowVariant.NEON_TETRA.getModel();
                        case 11 -> MinnowVariant.BLUE_NEON_RASBORA.getModel();
                        case 12 -> MinnowVariant.SCISSORTAIL_RASBORA.getModel();
                        case 13 -> MinnowVariant.MOSQUITO_RASABORA.getModel();
                        case 14 -> MinnowVariant.MARBLED_HATCHETFISH.getModel();
                        case 15 -> MinnowVariant.SILVER_HATCHETFISH.getModel();
                        case 16 -> MinnowVariant.DRAGONFIN_TETRA.getModel();
                        case 17 -> MinnowVariant.CHERRY_BARB.getModel();
                        case 18 -> MinnowVariant.GOLDEN_BARB.getModel();
                        case 19 -> MinnowVariant.TORPEDO_BARB.getModel();
                        case 20 -> MinnowVariant.ALESTES_TETRA.getModel();
                        default -> MinnowVariant.SIXBAR_DISTICHODUS.getModel();
                    };
                    skin = switch (var) {
                        case 1 -> MinnowVariant.FLAGTAIL_PROCHILODUS.getSkin();
                        case 2 -> MinnowVariant.COPELLA_TETRA.getSkin();
                        case 3 -> MinnowVariant.PIABUCO.getSkin();
                        case 4 -> MinnowVariant.HARLEQUIN_RASBORA.getSkin();
                        case 5 -> MinnowVariant.ODESSA_BARB.getSkin();
                        case 6 -> MinnowVariant.RUBY_BARB.getSkin();
                        case 7 -> MinnowVariant.BANDED_ASTYANAX.getSkin();
                        case 8 -> MinnowVariant.TETRAZONA_BARB.getSkin();
                        case 9 -> MinnowVariant.MASKED_BARB.getSkin();
                        case 10 -> MinnowVariant.NEON_TETRA.getSkin();
                        case 11 -> MinnowVariant.BLUE_NEON_RASBORA.getSkin();
                        case 12 -> MinnowVariant.SCISSORTAIL_RASBORA.getSkin();
                        case 13 -> MinnowVariant.MOSQUITO_RASABORA.getSkin();
                        case 14 -> MinnowVariant.MARBLED_HATCHETFISH.getSkin();
                        case 15 -> MinnowVariant.SILVER_HATCHETFISH.getSkin();
                        case 16 -> MinnowVariant.DRAGONFIN_TETRA.getSkin();
                        case 17 -> MinnowVariant.CHERRY_BARB.getSkin();
                        case 18 -> MinnowVariant.GOLDEN_BARB.getSkin();
                        case 19 -> MinnowVariant.TORPEDO_BARB.getSkin();
                        case 20 -> MinnowVariant.ALESTES_TETRA.getSkin();
                        default -> MinnowVariant.SIXBAR_DISTICHODUS.getSkin();
                    };
                } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207605_)) {
                    int var = this.m_217043_().m_188503_(11);
                    model = switch (var) {
                        case 1 -> MinnowVariant.GALAXIAS.getModel();
                        case 2 -> MinnowVariant.SAILFIN_SHINER.getModel();
                        case 3 -> MinnowVariant.FAT_HEAD_MINNOW.getModel();
                        case 4 -> MinnowVariant.RED_TAIL_ASTYANAX.getModel();
                        case 5 -> MinnowVariant.BITTERLING.getModel();
                        case 6 -> MinnowVariant.BANDED_ASTYANAX.getModel();
                        case 7 -> MinnowVariant.STREAKED_PROCHILODUS.getModel();
                        case 8 -> MinnowVariant.TINFOIL_BARB.getModel();
                        case 9 -> MinnowVariant.SICKLEFIN_BARB.getModel();
                        case 10 -> MinnowVariant.BLACKLINETAIL_TETRA.getModel();
                        default -> MinnowVariant.DELTA_SMELT.getModel();
                    };
                    skin = switch (var) {
                        case 1 -> MinnowVariant.GALAXIAS.getSkin();
                        case 2 -> MinnowVariant.SAILFIN_SHINER.getSkin();
                        case 3 -> MinnowVariant.FAT_HEAD_MINNOW.getSkin();
                        case 4 -> MinnowVariant.RED_TAIL_ASTYANAX.getSkin();
                        case 5 -> MinnowVariant.BITTERLING.getSkin();
                        case 6 -> MinnowVariant.BANDED_ASTYANAX.getSkin();
                        case 7 -> MinnowVariant.STREAKED_PROCHILODUS.getSkin();
                        case 8 -> MinnowVariant.TINFOIL_BARB.getSkin();
                        case 9 -> MinnowVariant.SICKLEFIN_BARB.getSkin();
                        case 10 -> MinnowVariant.BLACKLINETAIL_TETRA.getSkin();
                        default -> MinnowVariant.DELTA_SMELT.getSkin();
                    };
                } else if (pLevel.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220595_)) {
                    int var = this.m_217043_().m_188503_(3);
                    model = switch (var) {
                        case 1 -> MinnowVariant.GALAXIAS.getModel();
                        case 2 -> MinnowVariant.STRIPED_MOJARRA.getModel();
                        default -> MinnowVariant.DELTA_SMELT.getModel();
                    };
                    skin = switch (var) {
                        case 1 -> MinnowVariant.GALAXIAS.getSkin();
                        case 2 -> MinnowVariant.STRIPED_MOJARRA.getSkin();
                        default -> MinnowVariant.DELTA_SMELT.getSkin();
                    };
                } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207604_)) {
                    int var = this.m_217043_().m_188503_(4);
                    model = switch (var) {
                        case 1 -> MinnowVariant.ATLANTIC_HERRING.getModel();
                        case 2 -> MinnowVariant.GALAXIAS.getModel();
                        case 3 -> MinnowVariant.STRIPED_MOJARRA.getModel();
                        default -> MinnowVariant.DELTA_SMELT.getModel();
                    };
                    skin = switch (var) {
                        case 1 -> MinnowVariant.ATLANTIC_HERRING.getSkin();
                        case 2 -> MinnowVariant.GALAXIAS.getSkin();
                        case 3 -> MinnowVariant.STRIPED_MOJARRA.getSkin();
                        default -> MinnowVariant.DELTA_SMELT.getSkin();
                    };
                } else {
                    MinnowVariant variant = (MinnowVariant)((Object)Util.m_214670_((Object[])MinnowVariant.values(), (RandomSource)this.f_19796_));
                    model = variant.getModel();
                    skin = variant.getSkin();
                }
                pSpawnData = new MinnowGroupData(this, model, skin);
            }
            this.setVariantModel(model);
            this.setVariantSkin(skin);
        }
        return pSpawnData;
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        MinnowEntity baby = (MinnowEntity)((EntityType)YAFMEntities.MINNOW.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.m_27497_(true);
            baby.setVariantModel(this.getVariantModel());
            baby.setVariantSkin(this.getVariantSkin());
        }
        return baby;
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        MinnowEntity mate = (MinnowEntity)pOtherAnimal;
        return super.canMate(pOtherAnimal) && mate.getVariantModel() == this.getVariantModel() && mate.getVariantSkin() == this.getVariantSkin();
    }

    @Override
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.MINNOW_BUCKET.get());
    }

    public static boolean m_218282_(EntityType<? extends WaterAnimal> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return !pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_207603_) && (pLevel.m_204166_(pPos).m_203656_(YAFMTags.Biomes.MINNOW_SURFACE_BIOMES) && pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) || pPos.m_123342_() <= pLevel.m_5736_() - 33 && pLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_) && (pLevel.m_45524_(pPos, 0) == 0 || pLevel.m_204166_(pPos).m_203565_(Biomes.f_151785_)));
    }

    public static enum MinnowVariant {
        FLAGTAIL_PROCHILODUS(0, "flagtail_prochilodus"),
        SICKLEFIN_BARB(1, "sicklefin_barb"),
        SIXBAR_DISTICHODUS(2, "sixbar_distichodus"),
        STREAKED_PROCHILODUS(3, "streaked_prochilodus"),
        TINFOIL_BARB(4, "tinfoil_barb"),
        DRAGONFIN_TETRA(10, "dragonfin_tetra"),
        SILVER_HATCHETFISH(11, "silver_hatchetfish"),
        MARBLED_HATCHETFISH(12, "marbled_hatchetfish"),
        BANDED_ASTYANAX(20, "banded_astyanax"),
        BITTERLING(21, "bitterling"),
        HARLEQUIN_RASBORA(22, "harlequin_rasbora"),
        MASKED_BARB(23, "masked_barb"),
        ODESSA_BARB(24, "odessa_barb"),
        RUBY_BARB(25, "ruby_barb"),
        STRIPED_MOJARRA(26, "striped_mojarra"),
        TETRAZONA_BARB(27, "tetrazona_barb"),
        ALESTES_TETRA(30, "alestes_tetra"),
        BUENOS_AIRES_TETRA(31, "buenos_aires_tetra"),
        CHERRY_BARB(32, "cherry_barb"),
        FAT_HEAD_MINNOW(33, "fat_head_minnow"),
        GIANT_DANIO(34, "giant_danio"),
        GOLDEN_BARB(35, "golden_barb"),
        MEXICAN_CAVE_TETRA(36, "mexican_cave_tetra"),
        RED_TAIL_ASTYANAX(37, "red_tail_astyanax"),
        SAILFIN_SHINER(38, "sailfin_shiner"),
        TORPEDO_BARB(39, "torpedo_barb"),
        BLACKLINETAIL_TETRA(310, "blacklinetail_tetra"),
        BLUE_NEON_RASBORA(40, "blue_neon_rasbora"),
        CARDINAL_TETRA(41, "cardinal_tetra"),
        CHILI_RASBORA(42, "chili_rasbora"),
        MOSQUITO_RASABORA(43, "mosquito_rasbora"),
        NEON_GREEN_RASBORA(44, "neon_green_rasbora"),
        NEON_TETRA(45, "neon_tetra"),
        SCISSORTAIL_RASBORA(46, "scissortail_rasbora"),
        ATLANTIC_HERRING(50, "atlantic_herring"),
        COPELLA_TETRA(51, "copella_tetra"),
        DELTA_SMELT(52, "delta_smelt"),
        GALAXIAS(53, "galaxias"),
        PIABUCO(54, "piabuco"),
        SOUTHERN_CAVE_FISH(55, "southern_cave_fish");

        private final int joinedVariant;
        private final String name;
        private static final IntFunction<MinnowVariant> BY_ID;

        private MinnowVariant(int variant, String name) {
            this.joinedVariant = variant;
            this.name = name;
        }

        public int getJoinedVariant() {
            return this.joinedVariant;
        }

        public int getModel() {
            return this.joinedVariant > 100 ? this.joinedVariant / 100 : this.joinedVariant / 10;
        }

        public int getSkin() {
            return this.joinedVariant > 100 ? this.joinedVariant % 100 : this.joinedVariant % 10;
        }

        public String getName() {
            return this.name;
        }

        public String getModelName() {
            return switch (this.getModel()) {
                case 1 -> "hatchet";
                case 2 -> "round";
                case 3 -> "slim";
                case 4 -> "small";
                case 5 -> "thin";
                default -> "big";
            };
        }

        public static MinnowVariant byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.m_262845_(MinnowVariant::getJoinedVariant, (Object[])MinnowVariant.values(), (Object)((Object)TINFOIL_BARB));
        }
    }

    static class MinnowGroupData
    extends VariantSchoolingFish.SchoolSpawnGroupData {
        final int variantModel;
        final int variantSkin;

        MinnowGroupData(MinnowEntity pLeader, int pVariantModel, int pVariantSkin) {
            super(pLeader);
            this.variantModel = pVariantModel;
            this.variantSkin = pVariantSkin;
        }

        public int getVariantModel() {
            return this.variantModel;
        }

        public int getVariantSkin() {
            return this.variantSkin;
        }
    }
}

