/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.FollowIndiscriminateSchoolLeaderGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.SchoolingFish;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuppyEntity
extends SchoolingFish
implements GeoEntity {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.guppy.swim");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.guppy.flop");
    private static final EntityDataAccessor<Integer> FIN_MODEL = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FIN_COLOR = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAIL_MODEL = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAIL_COLOR = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN_1 = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN_2 = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN_1_COLOR = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN_2_COLOR = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_PATTERN_1 = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_PATTERN_2 = SynchedEntityData.m_135353_(GuppyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GuppyEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.65f);
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowIndiscriminateSchoolLeaderGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && !player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YAFMItems.FISHING_HAT.get());
            }
            return false;
        }));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 25));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FIN_MODEL, (Object)0);
        this.f_19804_.m_135372_(FIN_COLOR, (Object)0);
        this.f_19804_.m_135372_(TAIL_MODEL, (Object)0);
        this.f_19804_.m_135372_(TAIL_COLOR, (Object)0);
        this.f_19804_.m_135372_(PATTERN_1, (Object)0);
        this.f_19804_.m_135372_(PATTERN_2, (Object)0);
        this.f_19804_.m_135372_(PATTERN_1_COLOR, (Object)0);
        this.f_19804_.m_135372_(PATTERN_2_COLOR, (Object)0);
        this.f_19804_.m_135372_(HAS_PATTERN_1, (Object)false);
        this.f_19804_.m_135372_(HAS_PATTERN_2, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FinModel", this.getFinModel());
        compound.m_128405_("FinColor", this.getFinColor());
        compound.m_128405_("TailModel", this.getTailModel());
        compound.m_128405_("TailColor", this.getTailColor());
        compound.m_128379_("HasMainPattern", this.getHasMainPattern().booleanValue());
        compound.m_128405_("MainPattern", this.getMainPattern());
        compound.m_128405_("MainPatternColor", this.getMainPatternColor());
        compound.m_128379_("HasSecondaryPattern", this.getHasSecondPattern().booleanValue());
        compound.m_128405_("SecondaryPattern", this.getSecondPattern());
        compound.m_128405_("SecondaryPatternColor", this.getSecondPatternColor());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFinModel(compound.m_128451_("FinModel"));
        this.setFinColor(compound.m_128451_("FinColor"));
        this.setTailModel(compound.m_128451_("TailModel"));
        this.setTailColor(compound.m_128451_("TailColor"));
        this.setHasMainPattern(compound.m_128471_("HasMainPattern"));
        this.setMainPattern(compound.m_128451_("MainPattern"));
        this.setMainPatternColor(compound.m_128451_("MainPatternColor"));
        this.setHasSecondPattern(compound.m_128471_("HasSecondaryPattern"));
        this.setSecondPattern(compound.m_128451_("SecondaryPattern"));
        this.setSecondPatternColor(compound.m_128451_("SecondaryPatternColor"));
    }

    public int getFinModel() {
        return (Integer)this.f_19804_.m_135370_(FIN_MODEL);
    }

    public void setFinModel(int variant) {
        this.f_19804_.m_135381_(FIN_MODEL, (Object)variant);
    }

    public int getFinColor() {
        return (Integer)this.f_19804_.m_135370_(FIN_COLOR);
    }

    public void setFinColor(int variant) {
        this.f_19804_.m_135381_(FIN_COLOR, (Object)variant);
    }

    public int getTailModel() {
        return (Integer)this.f_19804_.m_135370_(TAIL_MODEL);
    }

    public void setTailModel(int variant) {
        this.f_19804_.m_135381_(TAIL_MODEL, (Object)variant);
    }

    public int getTailColor() {
        return (Integer)this.f_19804_.m_135370_(TAIL_COLOR);
    }

    public void setTailColor(int variant) {
        this.f_19804_.m_135381_(TAIL_COLOR, (Object)variant);
    }

    public Boolean getHasMainPattern() {
        return (Boolean)this.f_19804_.m_135370_(HAS_PATTERN_1);
    }

    public void setHasMainPattern(Boolean variant) {
        this.f_19804_.m_135381_(HAS_PATTERN_1, (Object)variant);
    }

    public int getMainPattern() {
        return (Integer)this.f_19804_.m_135370_(PATTERN_1);
    }

    public void setMainPattern(int variant) {
        this.f_19804_.m_135381_(PATTERN_1, (Object)variant);
    }

    public int getMainPatternColor() {
        return (Integer)this.f_19804_.m_135370_(PATTERN_1_COLOR);
    }

    public void setMainPatternColor(int variant) {
        this.f_19804_.m_135381_(PATTERN_1_COLOR, (Object)variant);
    }

    public Boolean getHasSecondPattern() {
        return (Boolean)this.f_19804_.m_135370_(HAS_PATTERN_2);
    }

    public void setHasSecondPattern(Boolean variant) {
        this.f_19804_.m_135381_(HAS_PATTERN_2, (Object)variant);
    }

    public int getSecondPattern() {
        return (Integer)this.f_19804_.m_135370_(PATTERN_2);
    }

    public void setSecondPattern(int variant) {
        this.f_19804_.m_135381_(PATTERN_2, (Object)variant);
    }

    public int getSecondPatternColor() {
        return (Integer)this.f_19804_.m_135370_(PATTERN_2_COLOR);
    }

    public void setSecondPatternColor(int variant) {
        this.f_19804_.m_135381_(PATTERN_2_COLOR, (Object)variant);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        compoundnbt.m_128405_("FinModel", this.getFinModel());
        compoundnbt.m_128405_("FinColor", this.getFinColor());
        compoundnbt.m_128405_("TailModel", this.getTailModel());
        compoundnbt.m_128405_("TailColor", this.getTailColor());
        compoundnbt.m_128379_("HasMainPattern", this.getHasMainPattern().booleanValue());
        compoundnbt.m_128405_("MainPattern", this.getMainPattern());
        compoundnbt.m_128405_("MainPatternColor", this.getMainPatternColor());
        compoundnbt.m_128379_("HasSecondaryPattern", this.getHasSecondPattern().booleanValue());
        compoundnbt.m_128405_("SecondaryPattern", this.getSecondPattern());
        compoundnbt.m_128405_("SecondaryPatternColor", this.getSecondPatternColor());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("VariantSkin", 3)) {
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
            this.setFinModel(pDataTag.m_128451_("FinModel"));
            this.setFinColor(pDataTag.m_128451_("FinColor"));
            this.setTailModel(pDataTag.m_128451_("TailModel"));
            this.setTailColor(pDataTag.m_128451_("TailColor"));
            this.setHasMainPattern(pDataTag.m_128471_("HasMainPattern"));
            this.setMainPattern(pDataTag.m_128451_("MainPattern"));
            this.setMainPatternColor(pDataTag.m_128451_("MainPatternColor"));
            this.setHasSecondPattern(pDataTag.m_128471_("HasSecondaryPattern"));
            this.setSecondPattern(pDataTag.m_128451_("SecondaryPattern"));
            this.setSecondPatternColor(pDataTag.m_128451_("SecondaryPatternColor"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else {
            this.setVariantSkin(this.f_19796_.m_188503_(12));
            this.setFinModel(this.f_19796_.m_188503_(2));
            this.setFinColor(this.f_19796_.m_188503_(22));
            this.setTailModel(this.f_19796_.m_188503_(19));
            this.setTailColor(this.f_19796_.m_188503_(22));
            this.setHasMainPattern(this.f_19796_.m_188503_(3) == 0);
            this.setMainPattern(this.f_19796_.m_188503_(11));
            this.setMainPatternColor(this.f_19796_.m_188503_(22));
            this.setHasSecondPattern(this.f_19796_.m_188503_(3) == 0);
            this.setSecondPattern(this.f_19796_.m_188503_(18));
            this.setSecondPatternColor(this.f_19796_.m_188503_(22));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static String getFinsName(int fin) {
        if (fin == 0) {
            return "jumbo";
        }
        return "regular";
    }

    public static String getTailName(int pattern) {
        return switch (pattern) {
            case 1 -> "btmpin";
            case 2 -> "btmsword";
            case 3 -> "drkcapped";
            case 4 -> "drkmoon";
            case 5 -> "drkmosaic";
            case 6 -> "drkstreak";
            case 7 -> "flag";
            case 8 -> "lhtcapped";
            case 9 -> "lhtmoon";
            case 10 -> "lhtmosaic";
            case 11 -> "lhtstreak";
            case 12 -> "lyre";
            case 13 -> "scissor";
            case 14 -> "square";
            case 15 -> "sunrise";
            case 16 -> "sword";
            case 17 -> "toppin";
            case 18 -> "topsword";
            default -> "round";
        };
    }

    public static String getMainPatternName(int pattern) {
        return switch (pattern) {
            case 1 -> "checkered2";
            case 2 -> "line1";
            case 3 -> "line2";
            case 4 -> "striped1";
            case 5 -> "striped2";
            case 6 -> "mask";
            case 7 -> "koi";
            case 8 -> "dipped";
            case 9 -> "belly";
            case 10 -> "fullbody";
            default -> "checkered1";
        };
    }

    public static String getSecondPatternName(int pattern) {
        return switch (pattern) {
            case 1 -> "checkered2";
            case 2 -> "line1";
            case 3 -> "line2";
            case 4 -> "striped1";
            case 5 -> "striped2";
            case 6 -> "mask";
            case 7 -> "koi";
            case 8 -> "dipped";
            case 9 -> "belly";
            case 10 -> "dot1";
            case 11 -> "dot2";
            case 12 -> "dot3";
            case 13 -> "dot4";
            case 14 -> "dot5";
            case 15 -> "doubledot";
            case 16 -> "coat";
            case 17 -> "bar";
            default -> "checkered1";
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    protected <E extends GuppyEntity> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            event.setAndContinue(SWIM);
            if (this.m_6162_()) {
                event.getController().setAnimationSpeed(2.0);
            }
        } else {
            event.setAndContinue(FLOP);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.GUPPY_BUCKET.get());
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_((Item)YAFMItems.REGULAR_FEED.get())) {
            this.setFeedQuality(0);
        }
        if (itemstack.m_150930_((Item)YAFMItems.QUALITY_FEED.get())) {
            this.setFeedQuality(1);
        }
        if (itemstack.m_150930_((Item)YAFMItems.GREAT_FEED.get())) {
            this.setFeedQuality(2);
        }
        if (itemstack.m_150930_((Item)YAFMItems.PREMIUM_FEED.get())) {
            this.setFeedQuality(3);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        GuppyEntity otherParent = (GuppyEntity)pOtherParent;
        GuppyEntity baby = (GuppyEntity)((EntityType)YAFMEntities.GUPPY.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            int secondPatternType;
            boolean hasSecondPattern;
            int mainPatternColor;
            int mainPatternType;
            boolean hasMainPattern;
            int tailColor;
            int tailModel;
            int finColor;
            int finModel;
            int skin;
            int lowerQuality = Math.min(this.getFeedQuality(), otherParent.getFeedQuality());
            int secondPatternColor = switch (lowerQuality) {
                case 1 -> {
                    if (this.f_19796_.m_188499_()) {
                        skin = this.f_19796_.m_188503_(12);
                        finModel = this.f_19796_.m_188503_(2);
                        finColor = this.f_19796_.m_188503_(22);
                        tailModel = this.f_19796_.m_188503_(19);
                        tailColor = this.f_19796_.m_188503_(22);
                        hasMainPattern = this.f_19796_.m_188503_(3) == 0;
                        mainPatternType = this.f_19796_.m_188503_(11);
                        mainPatternColor = this.f_19796_.m_188503_(22);
                        hasSecondPattern = this.f_19796_.m_188503_(3) == 0;
                        secondPatternType = this.f_19796_.m_188503_(18);
                        yield this.f_19796_.m_188503_(22);
                    }
                    skin = this.f_19796_.m_188499_() ? this.getVariantSkin() : otherParent.getVariantSkin();
                    finModel = this.f_19796_.m_188499_() ? this.getFinModel() : otherParent.getFinModel();
                    finColor = this.f_19796_.m_188499_() ? this.getFinColor() : otherParent.getFinColor();
                    tailModel = this.f_19796_.m_188499_() ? this.getTailModel() : otherParent.getTailModel();
                    tailColor = this.f_19796_.m_188499_() ? this.getTailColor() : otherParent.getTailColor();
                    hasMainPattern = this.f_19796_.m_188499_() ? this.getHasMainPattern() : otherParent.getHasMainPattern();
                    mainPatternType = this.f_19796_.m_188499_() ? this.getMainPattern() : otherParent.getMainPattern();
                    mainPatternColor = this.f_19796_.m_188499_() ? this.getMainPatternColor() : otherParent.getMainPatternColor();
                    hasSecondPattern = this.f_19796_.m_188499_() ? this.getHasSecondPattern() : otherParent.getHasSecondPattern();
                    secondPatternType = this.f_19796_.m_188499_() ? this.getSecondPattern() : otherParent.getSecondPattern();
                    yield this.f_19796_.m_188499_() ? this.getSecondPatternColor() : otherParent.getSecondPatternColor();
                }
                case 2 -> {
                    skin = this.f_19796_.m_188499_() ? this.getVariantSkin() : otherParent.getVariantSkin();
                    finModel = this.f_19796_.m_188499_() ? this.getFinModel() : otherParent.getFinModel();
                    finColor = this.f_19796_.m_188499_() ? this.getFinColor() : otherParent.getFinColor();
                    tailModel = this.f_19796_.m_188499_() ? this.getTailModel() : otherParent.getTailModel();
                    tailColor = this.f_19796_.m_188499_() ? this.getTailColor() : otherParent.getTailColor();
                    hasMainPattern = this.f_19796_.m_188499_() ? this.getHasMainPattern() : otherParent.getHasMainPattern();
                    mainPatternType = this.f_19796_.m_188499_() ? this.getMainPattern() : otherParent.getMainPattern();
                    mainPatternColor = this.f_19796_.m_188499_() ? this.getMainPatternColor() : otherParent.getMainPatternColor();
                    hasSecondPattern = this.f_19796_.m_188499_() ? this.getHasSecondPattern() : otherParent.getHasSecondPattern();
                    secondPatternType = this.f_19796_.m_188499_() ? this.getSecondPattern() : otherParent.getSecondPattern();
                    yield this.f_19796_.m_188499_() ? this.getSecondPatternColor() : otherParent.getSecondPatternColor();
                }
                case 3 -> {
                    boolean parent = this.f_19796_.m_188499_();
                    skin = parent ? this.getVariantSkin() : otherParent.getVariantSkin();
                    finModel = parent ? this.getFinModel() : otherParent.getFinModel();
                    finColor = parent ? this.getFinColor() : otherParent.getFinColor();
                    tailModel = parent ? this.getTailModel() : otherParent.getTailModel();
                    tailColor = parent ? this.getTailColor() : otherParent.getTailColor();
                    hasMainPattern = parent ? this.getHasMainPattern() : otherParent.getHasMainPattern();
                    mainPatternType = parent ? this.getMainPattern() : otherParent.getMainPattern();
                    mainPatternColor = parent ? this.getMainPatternColor() : otherParent.getMainPatternColor();
                    hasSecondPattern = parent ? this.getHasSecondPattern() : otherParent.getHasSecondPattern();
                    secondPatternType = parent ? this.getSecondPattern() : otherParent.getSecondPattern();
                    yield parent ? this.getSecondPatternColor() : otherParent.getSecondPatternColor();
                }
                default -> {
                    skin = this.f_19796_.m_188503_(12);
                    finModel = this.f_19796_.m_188503_(2);
                    finColor = this.f_19796_.m_188503_(22);
                    tailModel = this.f_19796_.m_188503_(19);
                    tailColor = this.f_19796_.m_188503_(22);
                    hasMainPattern = this.f_19796_.m_188503_(3) == 0;
                    mainPatternType = this.f_19796_.m_188503_(11);
                    mainPatternColor = this.f_19796_.m_188503_(22);
                    hasSecondPattern = this.f_19796_.m_188503_(3) == 0;
                    secondPatternType = this.f_19796_.m_188503_(18);
                    yield this.f_19796_.m_188503_(22);
                }
            };
            baby.setVariantSkin(skin);
            baby.setFinModel(finModel);
            baby.setFinColor(finColor);
            baby.setTailModel(tailModel);
            baby.setTailColor(tailColor);
            baby.setHasMainPattern(hasMainPattern);
            baby.setMainPattern(mainPatternType);
            baby.setMainPatternColor(mainPatternColor);
            baby.setHasSecondPattern(hasSecondPattern);
            baby.setSecondPattern(secondPatternType);
            baby.setSecondPatternColor(secondPatternColor);
            baby.m_27497_(true);
        }
        return baby;
    }

    @Override
    public void spawnChildFromBreeding(ServerLevel pLevel, BreedableWaterAnimal pMate) {
        boolean cancelled;
        BreedableWaterAnimal ageablemob = this.getBreedOffspring(pLevel, pMate);
        BreedableWaterAnimal ageableMob2 = null;
        BreedableWaterAnimal ageableMob3 = null;
        BreedableWaterAnimal ageableMob4 = null;
        BreedableWaterAnimal ageableMob5 = null;
        BreedableWaterAnimal.BabyFishSpawnEvent event = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageablemob);
        ageablemob = event.getChild();
        if (this.f_19796_.m_188499_() || this.f_19796_.m_188499_()) {
            ageableMob2 = this.getBreedOffspring(pLevel, pMate);
            BreedableWaterAnimal.BabyFishSpawnEvent event2 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob2);
            ageableMob2 = event2.getChild();
            if (this.f_19796_.m_188499_()) {
                ageableMob3 = this.getBreedOffspring(pLevel, pMate);
                BreedableWaterAnimal.BabyFishSpawnEvent event3 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob3);
                ageableMob3 = event3.getChild();
                if (this.f_19796_.m_188499_()) {
                    ageableMob4 = this.getBreedOffspring(pLevel, pMate);
                    BreedableWaterAnimal.BabyFishSpawnEvent event4 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob4);
                    ageableMob4 = event4.getChild();
                    if (this.f_19796_.m_188499_()) {
                        ageableMob5 = this.getBreedOffspring(pLevel, pMate);
                        BreedableWaterAnimal.BabyFishSpawnEvent event5 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob5);
                        ageableMob5 = event5.getChild();
                    }
                }
            }
        }
        if (cancelled = MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.setAge(6000);
            pMate.setAge(6000);
            this.resetLove();
            pMate.resetLove();
            return;
        }
        if (ageablemob != null) {
            ageablemob.setAge(-12000);
            ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageablemob);
            pLevel.m_47205_((Entity)ageablemob);
            if (ageableMob2 != null) {
                ageableMob2.setAge(-12000);
                ageableMob2.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob2);
                pLevel.m_47205_((Entity)ageableMob2);
                if (ageableMob3 != null) {
                    ageableMob3.setAge(-12000);
                    ageableMob3.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob3);
                    pLevel.m_47205_((Entity)ageableMob3);
                    if (ageableMob4 != null) {
                        ageableMob4.setAge(-12000);
                        ageableMob4.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                        this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob4);
                        pLevel.m_47205_((Entity)ageableMob4);
                        if (ageableMob5 != null) {
                            ageableMob5.setAge(-12000);
                            ageableMob5.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob5);
                            pLevel.m_47205_((Entity)ageableMob5);
                        }
                    }
                }
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

