/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import java.util.EnumSet;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.voidarkana.fintastic.common.block.YAFMBlocks;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.common.sound.YAFMSounds;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;

public class Gourami
extends BucketableFishEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();
    public final AnimationState investigatingAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);
    private static final EntityDataAccessor<Integer> VARIANT_MODEL = SynchedEntityData.m_135353_(Gourami.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT_SKIN = SynchedEntityData.m_135353_(Gourami.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> INVESTIGATING_TIME = SynchedEntityData.m_135353_(Gourami.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_INVESTIGATE = SynchedEntityData.m_135353_(Gourami.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_BREATHE = SynchedEntityData.m_135353_(Gourami.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Override
    public boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public Gourami(EntityType<? extends BucketableFishEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_6210_();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return switch (this.getVariantModel()) {
            case 1, 2 -> super.m_6972_(pPose);
            default -> super.m_6972_(pPose).m_20390_(2.0f, 3.5f);
        };
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new GouramiInvestigateGoal(this, 40));
        this.f_21345_.m_25352_(5, (Goal)new GouramiBreatheGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, (double)0.6f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_MODEL, (Object)0);
        this.f_19804_.m_135372_(VARIANT_SKIN, (Object)0);
        this.f_19804_.m_135372_(INVESTIGATING_TIME, (Object)0);
        this.f_19804_.m_135372_(WANTS_TO_INVESTIGATE, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_BREATHE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("VariantModel", this.getVariantModel());
        pCompound.m_128405_("VariantSkin", this.getVariantSkin());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariantModel(pCompound.m_128451_("VariantModel"));
        this.setVariantSkin(pCompound.m_128451_("VariantSkin"));
    }

    public int getVariantModel() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_MODEL);
    }

    public void setVariantModel(int pVariant) {
        this.f_19804_.m_135381_(VARIANT_MODEL, (Object)pVariant);
    }

    public int getVariantSkin() {
        return (Integer)this.f_19804_.m_135370_(VARIANT_SKIN);
    }

    public void setVariantSkin(int pVariant) {
        this.f_19804_.m_135381_(VARIANT_SKIN, (Object)pVariant);
    }

    public int getInvestigatingTime() {
        return (Integer)this.f_19804_.m_135370_(INVESTIGATING_TIME);
    }

    public void setInvestigatingTime(int pTime) {
        this.f_19804_.m_135381_(INVESTIGATING_TIME, (Object)pTime);
    }

    public boolean isInvestigating() {
        return this.getInvestigatingTime() > 0;
    }

    public void setWantsToInvestigate(boolean wantsToInvestigate) {
        this.f_19804_.m_135381_(WANTS_TO_INVESTIGATE, (Object)wantsToInvestigate);
    }

    public boolean wantsToInvestigate() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_INVESTIGATE);
    }

    public void setWantsToBreathe(boolean wantsToBreathe) {
        this.f_19804_.m_135381_(WANTS_TO_BREATHE, (Object)wantsToBreathe);
    }

    public boolean wantsToBreathe() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_BREATHE);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Gourami baby = (Gourami)((EntityType)YAFMEntities.GOURAMI.get()).m_20615_((Level)pLevel);
        Gourami otherParent = (Gourami)pOtherParent;
        if (baby != null) {
            baby.m_27497_(true);
            baby.setVariantModel(this.f_19796_.m_188499_() ? this.getVariantModel() : otherParent.getVariantModel());
            baby.setVariantSkin(this.f_19796_.m_188499_() ? this.getVariantSkin() : otherParent.getVariantSkin());
        }
        return baby;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
        if (!this.wantsToInvestigate() && this.f_19796_.m_188503_(50) == 0) {
            this.setWantsToInvestigate(true);
        }
        if (!this.wantsToBreathe() && this.f_19796_.m_188503_(500) == 0) {
            this.setWantsToBreathe(true);
        }
        if (this.isInvestigating()) {
            int invTime = this.getInvestigatingTime();
            if (invTime - 1 == 0) {
                this.setWantsToInvestigate(false);
            }
            this.setInvestigatingTime(invTime - 1);
        }
        if (!this.isEyeInFluidType(Fluids.f_76193_.getFluidType()) && this.wantsToBreathe()) {
            this.setWantsToBreathe(false);
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
        this.flopAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
        this.investigatingAnimationState.m_246184_(this.isInvestigating(), this.f_19797_);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        compoundnbt.m_128405_("VariantModel", this.getVariantModel());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("Age", 3)) {
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
            this.setVariantModel(pDataTag.m_128451_("VariantModel"));
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
        } else {
            GouramiVariant variant = (GouramiVariant)((Object)Util.m_214670_((Object[])GouramiVariant.values(), (RandomSource)this.f_19796_));
            this.setVariantModel(variant.getModel());
            this.setVariantSkin(variant.getSkin());
            if (this.getVariantModel() == 0 && pReason == MobSpawnType.BUCKET) {
                this.setAge(-24000);
            }
        }
        this.m_20301_(this.m_6062_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.GOURAMI_BUCKET.get());
    }

    @Override
    public boolean canBeBucketed() {
        return this.getVariantModel() != 0 || this.getVariantModel() == 0 && this.m_6162_();
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        Gourami mate = (Gourami)pOtherAnimal;
        return super.canMate(pOtherAnimal) && (this.areBothSpottedGouramies(mate) || mate.getVariantModel() == this.getVariantModel() && mate.getVariantSkin() == this.getVariantSkin());
    }

    private boolean areBothSpottedGouramies(Gourami otherGourami) {
        int thisJoinedVariantID = Integer.decode(String.valueOf(this.getVariantModel()) + this.getVariantSkin());
        GouramiVariant thisGouramiVariant = GouramiVariant.byId(thisJoinedVariantID);
        int otherJoinedVariantID = Integer.decode(String.valueOf(otherGourami.getVariantModel()) + otherGourami.getVariantSkin());
        GouramiVariant otherGouramiVariant = GouramiVariant.byId(otherJoinedVariantID);
        return !(thisGouramiVariant != GouramiVariant.LAVENDER_THREE_SPOT_GOURAMI && thisGouramiVariant != GouramiVariant.BLUE_THREE_SPOT_GOURAMI && thisGouramiVariant != GouramiVariant.YELLOW_THREE_SPOT_GOURAMI || otherGouramiVariant != GouramiVariant.LAVENDER_THREE_SPOT_GOURAMI && otherGouramiVariant != GouramiVariant.BLUE_THREE_SPOT_GOURAMI && otherGouramiVariant != GouramiVariant.YELLOW_THREE_SPOT_GOURAMI);
    }

    @Override
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    protected SoundEvent m_7515_() {
        int joinedVariantID = Integer.decode(String.valueOf(this.getVariantModel()) + this.getVariantSkin());
        GouramiVariant gouramiVariant = GouramiVariant.byId(joinedVariantID);
        if (gouramiVariant == GouramiVariant.CROAKING_GOURAMI) {
            return (SoundEvent)YAFMSounds.GOURAMI_CROAK.get();
        }
        return super.m_7515_();
    }

    public int m_8100_() {
        return 180;
    }

    protected void addParticlesAroundSelf(ParticleOptions pParticleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(pParticleOption, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), d0, d1, d2);
        }
    }

    public static class GouramiInvestigateGoal
    extends MoveToBlockGoal {
        private final Gourami fish;
        int duration;
        int currentDuration;

        public GouramiInvestigateGoal(Gourami pMob, int duration) {
            super((PathfinderMob)pMob, 0.9, 16, 16);
            this.fish = pMob;
            this.duration = duration;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.fish.wantsToInvestigate();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.currentDuration > 0;
        }

        public void m_8056_() {
            this.currentDuration = this.duration;
            this.fish.m_9236_().m_7605_((Entity)this.fish, (byte)10);
            this.fish.setInvestigatingTime(0);
        }

        public void m_8037_() {
            BlockPos blockpos = this.m_6669_();
            this.fish.m_21563_().m_24950_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() - 0.5, (double)blockpos.m_123343_() + 0.5, 10.0f, (float)this.fish.m_8132_());
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() - 0.5, (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                }
                if (this.fish.isInvestigating()) {
                    this.fish.setInvestigatingTime(0);
                }
                if (this.currentDuration != this.duration) {
                    this.currentDuration = this.duration;
                }
            } else {
                if (!this.fish.isInvestigating() && this.currentDuration > 0) {
                    this.fish.setInvestigatingTime(40);
                    this.fish.m_21573_().m_26573_();
                }
                this.f_25600_ = 10;
                --this.currentDuration;
                if (this.currentDuration <= 0) {
                    this.fish.setInvestigatingTime(0);
                    this.fish.setWantsToInvestigate(false);
                    this.m_8041_();
                }
                --this.f_25601_;
            }
        }

        public void m_8041_() {
            this.f_25600_ = 10;
            if (this.currentDuration <= 0) {
                if (this.fish.randomSwimmingGoal != null) {
                    this.fish.randomSwimmingGoal.m_25751_();
                }
            } else {
                this.currentDuration = 0;
            }
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return blockstate.m_204336_(YAFMTags.Blocks.GOURAMI_INVESTIGATION_TARGETS) && !blockstate.m_60713_(Blocks.f_50037_) && !blockstate.m_60713_(Blocks.f_50038_) && !blockstate.m_60713_(Blocks.f_50196_) && !blockstate.m_60713_(YAFMBlocks.DUCKWEED.get());
        }
    }

    public static class GouramiBreatheGoal
    extends BreathAirGoal {
        private final Gourami fish;

        public GouramiBreatheGoal(Gourami pMob) {
            super((PathfinderMob)pMob);
            this.fish = pMob;
        }

        public boolean m_8036_() {
            return this.fish.wantsToBreathe();
        }

        public boolean m_6767_() {
            return true;
        }
    }

    public static enum GouramiVariant {
        OSPHRONEMUS_GORAMI(0, "osphronemus_gorami"),
        REDTAIL_GIANT_GOURAMI(1, "redtail_giant_gourami"),
        RUBY_RED_GIANT_GOURAMI(2, "ruby_red_giant_gourami"),
        BLUE_THREE_SPOT_GOURAMI(10, "blue_three_spot_gourami"),
        DWARF_GOURAMI(11, "dwarf_gourami"),
        HONEY_GOURAMI(12, "honey_gourami"),
        KISSING_GOURAMI(13, "kissing_gourami"),
        LAVENDER_THREE_SPOT_GOURAMI(14, "lavender_three_spot_gourami"),
        PEARL_GOURAMI(15, "pearl_gourami"),
        YELLOW_THREE_SPOT_GOURAMI(16, "yellow_three_spot_gourami"),
        BETTA_ALBIMARGINATA(20, "betta_albimarginata"),
        BETTA_MAHACHAI(21, "betta_mahachai"),
        BETTA_SPLENDENS_WILD(22, "betta_splendens_wild"),
        CROAKING_GOURAMI(23, "croaking_gourami");

        private final int joinedVariant;
        private final String name;
        private static final IntFunction<GouramiVariant> BY_ID;

        private GouramiVariant(int variant, String name) {
            this.joinedVariant = variant;
            this.name = name;
        }

        public int getJoinedVariant() {
            return this.joinedVariant;
        }

        public int getModel() {
            return this.joinedVariant / 10;
        }

        public int getSkin() {
            return this.joinedVariant % 10;
        }

        public String getName() {
            return this.name;
        }

        public String getModelName() {
            return switch (this.joinedVariant / 10) {
                case 1 -> "med";
                case 2 -> "small";
                default -> "huge";
            };
        }

        public static GouramiVariant byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.m_262845_(GouramiVariant::getJoinedVariant, (Object[])GouramiVariant.values(), (Object)((Object)OSPHRONEMUS_GORAMI));
        }
    }
}

