/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.FollowIndiscriminateSchoolLeaderGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.SchoolingFish;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArtemiaEntity
extends SchoolingFish
implements GeoEntity {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42576_});
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.artemia.swim");
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.artemia.idle");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.artemia.flop");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArtemiaEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.65f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowIndiscriminateSchoolLeaderGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && !player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YAFMItems.FISHING_HAT.get());
            }
            return false;
        }));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, WaterAnimal.class, 8.0f, 1.6, 1.4, entity -> entity.m_6095_().m_204039_(YAFMTags.EntityType.PREDATOR_FISH)));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 25));
    }

    public boolean isNinni() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && (s.toLowerCase().contains("ninnih_") || s.toLowerCase().contains("ninnih") || s.toLowerCase().contains("ninni") || s.toLowerCase().contains("sea monkey") || s.toLowerCase().contains("seamonkey"));
    }

    @Override
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.ARTEMIA_BUCKET.get());
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("VariantSkin", 3)) {
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else {
            this.setVariantSkin(this.f_19796_.m_188503_(3));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    protected <E extends ArtemiaEntity> PlayState Controller(AnimationState<ArtemiaEntity> event) {
        ArtemiaEntity entity = (ArtemiaEntity)event.getAnimatable();
        if (entity.m_20069_()) {
            if (event.isMoving()) {
                event.setAndContinue(SWIM);
                if (entity.m_6162_()) {
                    event.getController().setAnimationSpeed(2.0);
                }
            } else {
                event.setAndContinue(IDLE);
            }
        } else {
            event.setAndContinue(FLOP);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        ArtemiaEntity baby = (ArtemiaEntity)((EntityType)YAFMEntities.ARTEMIA.get()).m_20615_((Level)pLevel);
        ArtemiaEntity otherGuy = (ArtemiaEntity)pOtherParent;
        if (baby != null) {
            baby.setVariantSkin(this.f_19796_.m_188499_() ? this.getVariantSkin() : otherGuy.getVariantSkin());
            baby.m_27497_(true);
        }
        return baby;
    }

    @Override
    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0 && this.m_20280_((Entity)this.leader) > 3.0;
    }

    @Override
    public void spawnChildFromBreeding(ServerLevel pLevel, BreedableWaterAnimal pMate) {
        boolean cancelled;
        BreedableWaterAnimal ageablemob = this.getBreedOffspring(pLevel, pMate);
        BreedableWaterAnimal ageableMob2 = null;
        BreedableWaterAnimal ageableMob3 = null;
        BreedableWaterAnimal ageableMob4 = null;
        BreedableWaterAnimal ageableMob5 = null;
        BreedableWaterAnimal.BabyFishSpawnEvent event = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageablemob);
        ageablemob = event.getChild();
        if (this.f_19796_.m_188499_() || this.f_19796_.m_188499_()) {
            ageableMob2 = this.getBreedOffspring(pLevel, pMate);
            BreedableWaterAnimal.BabyFishSpawnEvent event2 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob2);
            ageableMob2 = event2.getChild();
            if (this.f_19796_.m_188499_()) {
                ageableMob3 = this.getBreedOffspring(pLevel, pMate);
                BreedableWaterAnimal.BabyFishSpawnEvent event3 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob3);
                ageableMob3 = event3.getChild();
                if (this.f_19796_.m_188499_()) {
                    ageableMob4 = this.getBreedOffspring(pLevel, pMate);
                    BreedableWaterAnimal.BabyFishSpawnEvent event4 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob4);
                    ageableMob4 = event4.getChild();
                    if (this.f_19796_.m_188499_()) {
                        ageableMob5 = this.getBreedOffspring(pLevel, pMate);
                        BreedableWaterAnimal.BabyFishSpawnEvent event5 = new BreedableWaterAnimal.BabyFishSpawnEvent(this, (Mob)this, (Mob)pMate, ageableMob5);
                        ageableMob5 = event5.getChild();
                    }
                }
            }
        }
        if (cancelled = MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.setAge(6000);
            pMate.setAge(6000);
            this.resetLove();
            pMate.resetLove();
            return;
        }
        if (ageablemob != null) {
            ageablemob.setAge(-12000);
            ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageablemob);
            pLevel.m_47205_((Entity)ageablemob);
            if (ageableMob2 != null) {
                ageableMob2.setAge(-12000);
                ageableMob2.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob2);
                pLevel.m_47205_((Entity)ageableMob2);
                if (ageableMob3 != null) {
                    ageableMob3.setAge(-12000);
                    ageableMob3.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob3);
                    pLevel.m_47205_((Entity)ageableMob3);
                    if (ageableMob4 != null) {
                        ageableMob4.setAge(-12000);
                        ageableMob4.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                        this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob4);
                        pLevel.m_47205_((Entity)ageableMob4);
                        if (ageableMob5 != null) {
                            ageableMob5.setAge(-12000);
                            ageableMob5.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                            this.finalizeSpawnChildFromBreeding(pLevel, pMate, ageableMob5);
                            pLevel.m_47205_((Entity)ageableMob5);
                        }
                    }
                }
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

