/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.block.custom;

import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.voidarkana.fintastic.common.block.YAFMBlocks;

public class DuckweedBlock
extends Block
implements IPlantable,
BonemealableBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_52346_ -> ((Direction)p_52346_.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    public static final IntegerProperty GROWTH_STAGE = IntegerProperty.m_61631_((String)"growth_stage", (int)0, (int)2);

    public DuckweedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (itemstack.m_150930_(YAFMBlocks.DUCKWEED.get().m_5456_()) && (Integer)blockstate.m_61143_((Property)GROWTH_STAGE) < 2) {
            this.usePlayerItem(pPlayer, pHand, itemstack);
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12581_, SoundSource.BLOCKS, 1.0f, 1.0f);
            int prev = (Integer)blockstate.m_61143_((Property)GROWTH_STAGE);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(prev + 1)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void usePlayerItem(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        if (!pPlayer.m_150110_().f_35937_) {
            pStack.m_41774_(1);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, GROWTH_STAGE});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = pContext.m_43725_().m_8055_(blockpos);
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockState blockstate1 = blockgetter.m_8055_(blockpos1);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos3);
        BlockState blockstate4 = blockgetter.m_8055_(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(pContext).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate1, blockstate, blockstate1.m_60783_((BlockGetter)blockgetter, blockpos1.m_7495_(), Direction.SOUTH))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate2, blockstate, blockstate2.m_60783_((BlockGetter)blockgetter, blockpos2.m_7495_(), Direction.WEST))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate3, blockstate, blockstate3.m_60783_((BlockGetter)blockgetter, blockpos3.m_7495_(), Direction.NORTH))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate4, blockstate, blockstate4.m_60783_((BlockGetter)blockgetter, blockpos4.m_7495_(), Direction.EAST))));
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Integer)pState.m_61143_((Property)GROWTH_STAGE) < 2;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : (pFacing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)pState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pFacingState, pState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, pFacing.m_122424_())))) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return DuckweedBlock.mayPlaceOn((BlockGetter)pLevel, pPos.m_7495_());
    }

    private static boolean mayPlaceOn(BlockGetter pLevel, BlockPos pPos) {
        FluidState fluidstate = pLevel.m_6425_(pPos);
        FluidState fluidstate1 = pLevel.m_6425_(pPos.m_7494_());
        return fluidstate.m_76152_() == Fluids.f_76193_ && fluidstate1.m_76152_() == Fluids.f_76191_;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return true;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = (Integer)pState.m_61143_((Property)GROWTH_STAGE);
        if (i < 2) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(i + 1)), 2);
        } else {
            DuckweedBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return true;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public boolean connectsTo(BlockState pState, BlockState thisState, boolean pIsSideSolid) {
        return !DuckweedBlock.m_152463_((BlockState)pState) && (pIsSideSolid || this.isDuckweedConnectable(pState, thisState));
    }

    private boolean isDuckweedConnectable(BlockState pState, BlockState thisState) {
        if (pState.m_60713_(YAFMBlocks.DUCKWEED.get()) && thisState.m_60713_(YAFMBlocks.DUCKWEED.get())) {
            return ((Integer)pState.m_61143_((Property)GROWTH_STAGE)).equals(thisState.m_61143_((Property)GROWTH_STAGE));
        }
        return false;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.WATER;
    }
}

