/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AquariumGlassPane
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
        p_55164_.put(Direction.UP, UP);
        p_55164_.put(Direction.DOWN, DOWN);
    })));

    public AquariumGlassPane(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)FACING) == Direction.NORTH) {
            return NORTH_SHAPE;
        }
        if (pState.m_61143_((Property)FACING) == Direction.WEST) {
            return WEST_SHAPE;
        }
        if (pState.m_61143_((Property)FACING) == Direction.SOUTH) {
            return SOUTH_SHAPE;
        }
        return EAST_SHAPE;
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)));
            }
        }
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pMirror.m_54848_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pMirror.m_54848_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockPos blockpos6 = blockpos.m_7495_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockState blockstate = blockgetter.m_8055_(blockpos1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos3);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos4);
        BlockState blockstate4 = blockgetter.m_8055_(blockpos5);
        BlockState blockstate5 = blockgetter.m_8055_(blockpos6);
        Direction direction = pContext.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(pContext).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate, direction)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate1, direction)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate2, direction)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate3, direction)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo(blockstate4, direction)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(blockstate5, direction)))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    private boolean connectsTo(BlockState pState, Direction direction) {
        if (pState.m_60713_((Block)this)) {
            return pState.m_61143_((Property)FACING) == direction;
        }
        return false;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        boolean flag = pFacingState.m_60713_((Block)this) && pFacingState.m_61143_((Property)FACING) == pState.m_61143_((Property)FACING);
        return (BlockState)pState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(flag));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, FACING, WATERLOGGED});
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

