/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.voidarkana.fintastic.client.FintasticLayers;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowBigModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowHatchetModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowRoundModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowSlimModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowSmallModel;
import net.voidarkana.fintastic.client.models.entity.minnows.MinnowThinModel;
import net.voidarkana.fintastic.common.entity.custom.MinnowEntity;
import org.jetbrains.annotations.Nullable;

public class MinnowRenderer
extends MobRenderer<MinnowEntity, FintasticModel<MinnowEntity>> {
    private final MinnowBigModel<MinnowEntity> minnowBigModel;
    private final MinnowHatchetModel<MinnowEntity> minnowHatchetModel;
    private final MinnowRoundModel<MinnowEntity> minnowRoundModel;
    private final MinnowSlimModel<MinnowEntity> minnowSlimModel;
    private final MinnowSmallModel<MinnowEntity> minnowSmallModel;
    private final MinnowThinModel<MinnowEntity> minnowThinModel;

    public MinnowRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new MinnowBigModel(pContext.m_174023_(FintasticLayers.MINNOW_BIG_LAYER)), 0.25f);
        this.minnowBigModel = new MinnowBigModel(pContext.m_174023_(FintasticLayers.MINNOW_BIG_LAYER));
        this.minnowHatchetModel = new MinnowHatchetModel(pContext.m_174023_(FintasticLayers.MINNOW_HATCHET_LAYER));
        this.minnowRoundModel = new MinnowRoundModel(pContext.m_174023_(FintasticLayers.MINNOW_ROUND_LAYER));
        this.minnowSlimModel = new MinnowSlimModel(pContext.m_174023_(FintasticLayers.MINNOW_SLIM_LAYER));
        this.minnowSmallModel = new MinnowSmallModel(pContext.m_174023_(FintasticLayers.MINNOW_SMALL_LAYER));
        this.minnowThinModel = new MinnowThinModel(pContext.m_174023_(FintasticLayers.MINNOW_THIN_LAYER));
    }

    public void render(MinnowEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        switch (entity.getVariantModel()) {
            case 1: {
                this.f_115290_ = this.minnowHatchetModel;
                break;
            }
            case 2: {
                this.f_115290_ = this.minnowRoundModel;
                break;
            }
            case 3: {
                this.f_115290_ = this.minnowSlimModel;
                break;
            }
            case 4: {
                this.f_115290_ = this.minnowSmallModel;
                break;
            }
            case 5: {
                this.f_115290_ = this.minnowThinModel;
                break;
            }
            default: {
                this.f_115290_ = this.minnowBigModel;
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(MinnowEntity pEntity) {
        int joinedVariantID = Integer.decode(String.valueOf(pEntity.getVariantModel()));
        MinnowEntity.MinnowVariant minnowVariant = MinnowEntity.MinnowVariant.byId(joinedVariantID);
        return new ResourceLocation("fintastic", "textures/entity/minnow/" + minnowVariant.getModelName() + "/" + minnowVariant.getName() + ".png");
    }

    @Nullable
    protected RenderType getRenderType(MinnowEntity pEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        int joinedVariantID = Integer.decode(String.valueOf(pEntity.getVariantModel()) + pEntity.getVariantSkin());
        MinnowEntity.MinnowVariant minnowVariant = MinnowEntity.MinnowVariant.byId(joinedVariantID);
        return RenderType.m_110452_((ResourceLocation)new ResourceLocation("fintastic", "textures/entity/minnow/" + minnowVariant.getModelName() + "/" + minnowVariant.getName() + ".png"));
    }

    protected void setupRotations(MinnowEntity pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pEntityLiving.currentRoll * 360.0f / 4.0f));
    }
}

