/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.voidarkana.fintastic.client.FintasticLayers;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.client.models.entity.gourami.GouramiHugeModel;
import net.voidarkana.fintastic.client.models.entity.gourami.GouramiMedModel;
import net.voidarkana.fintastic.client.models.entity.gourami.GouramiSmallModel;
import net.voidarkana.fintastic.common.entity.custom.Gourami;
import org.jetbrains.annotations.Nullable;

public class GouramiRenderer
extends MobRenderer<Gourami, FintasticModel<Gourami>> {
    private final GouramiHugeModel<Gourami> gouramiHugeModel;
    private final GouramiMedModel<Gourami> gouramiMedModel;
    private final GouramiSmallModel<Gourami> gouramiSmallModel;

    public GouramiRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new GouramiHugeModel(pContext.m_174023_(FintasticLayers.GOURAMI_HUGE_LAYER)), 0.25f);
        this.gouramiHugeModel = new GouramiHugeModel(pContext.m_174023_(FintasticLayers.GOURAMI_HUGE_LAYER));
        this.gouramiMedModel = new GouramiMedModel(pContext.m_174023_(FintasticLayers.GOURAMI_MED_LAYER));
        this.gouramiSmallModel = new GouramiSmallModel(pContext.m_174023_(FintasticLayers.GOURAMI_SMALL_LAYER));
    }

    public void render(Gourami entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        switch (entity.getVariantModel()) {
            case 1: {
                this.f_115290_ = this.gouramiMedModel;
                break;
            }
            case 2: {
                this.f_115290_ = this.gouramiSmallModel;
                break;
            }
            default: {
                this.f_115290_ = this.gouramiHugeModel;
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(Gourami pEntity) {
        int joinedVariantID = Integer.decode(String.valueOf(pEntity.getVariantModel()) + pEntity.getVariantSkin());
        Gourami.GouramiVariant gouramiVariant = Gourami.GouramiVariant.byId(joinedVariantID);
        return new ResourceLocation("fintastic", "textures/entity/gourami/" + gouramiVariant.getModelName() + "/gourami_" + gouramiVariant.getName() + ".png");
    }

    @Nullable
    protected RenderType getRenderType(Gourami pEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        int joinedVariantID = Integer.decode(String.valueOf(pEntity.getVariantModel()) + pEntity.getVariantSkin());
        Gourami.GouramiVariant gouramiVariant = Gourami.GouramiVariant.byId(joinedVariantID);
        return RenderType.m_110452_((ResourceLocation)new ResourceLocation("fintastic", "textures/entity/gourami/" + gouramiVariant.getModelName() + "/gourami_" + gouramiVariant.getName() + ".png"));
    }

    protected void setupRotations(Gourami pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pEntityLiving.currentRoll * 360.0f / 4.0f));
    }
}

