/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity.minnows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.fintastic.client.animation.MinnowAnims;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.common.entity.custom.MinnowEntity;

public class MinnowBigModel<T extends MinnowEntity>
extends FintasticModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart snout;
    private final ModelPart dorsalfin;
    private final ModelPart analfin;
    private final ModelPart leftfin;
    private final ModelPart rightfin;
    private final ModelPart tailfin;

    public MinnowBigModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.snout = this.body.m_171324_("snout");
        this.dorsalfin = this.body.m_171324_("dorsalfin");
        this.analfin = this.body.m_171324_("analfin");
        this.leftfin = this.body.m_171324_("leftfin");
        this.rightfin = this.body.m_171324_("rightfin");
        this.tailfin = this.body.m_171324_("tailfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-2.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)-3.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -4.0f, -1.0f, 4.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snout = body.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(-1.5f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)2.0f, (float)-1.5f));
        PartDefinition dorsalfin = body.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(0.0f, -6.0f, -3.0f, 0.0f, 6.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)2.0f));
        PartDefinition analfin = body.m_171599_("analfin", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(0.0f, -1.0f, -2.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)2.0f, (float)3.0f, (float)7.0f));
        PartDefinition leftfin = body.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.5912f, (float)2.8767f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        PartDefinition rightfin = body.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.4088f, (float)2.8767f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition tailfin = body.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(16, 15).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(MinnowEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateIdle(pEntity.idleAnimationState, MinnowAnims.IDLE, pAgeInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount)));
        this.animateIdle(pEntity.flopAnimationState, MinnowAnims.FLOP, pAgeInTicks, 1.0f, (float)pEntity.getTicksOutsideWater() / 3.0f);
        if (pEntity.m_20072_()) {
            this.swim_rot.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
            this.swim_rot.f_104205_ = pNetHeadYaw * ((float)Math.PI / 360);
            this.m_267799_(MinnowAnims.BIG_SWIM, pLimbSwing, pLimbSwingAmount, 2.0f, 3.0f);
        } else {
            this.swim_rot.m_233569_();
            this.m_288214_(MinnowAnims.BIG_FLOP);
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.4f, 0.4f, 0.4f);
            poseStack.m_85837_(0.0, 2.25, 0.0);
        }
        poseStack.m_85837_(0.0, 0.2, 0.0);
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

