/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;

public abstract class FintasticModel<E extends Entity>
extends HierarchicalModel<E> {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    private final float youngScaleFactor;
    private final float bodyYOffset;

    public FintasticModel(float pYoungScaleFactor, float pBodyYOffset) {
        this(pYoungScaleFactor, pBodyYOffset, RenderType::m_110458_);
    }

    public FintasticModel(float pYoungScaleFactor, float pBodyYOffset, Function<ResourceLocation, RenderType> pRenderType) {
        super(pRenderType);
        this.bodyYOffset = pBodyYOffset;
        this.youngScaleFactor = pYoungScaleFactor;
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        pPoseStack.m_85836_();
        if (this.f_102610_) {
            pPoseStack.m_85841_(this.youngScaleFactor, this.youngScaleFactor, this.youngScaleFactor);
            pPoseStack.m_252880_(0.0f, this.bodyYOffset, 0.0f);
        }
        this.m_142109_().m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        pPoseStack.m_85849_();
    }

    protected void animateIdle(AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks, float pSpeed, float pScale) {
        float scale = Math.max(0.0f, Math.min(1.0f - Math.abs(pSpeed), 1.0f));
        pAnimationState.m_216974_(pAgeInTicks, pSpeed);
        pAnimationState.m_216979_(p_233392_ -> KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)pAnimationDefinition, (long)p_233392_.m_216981_(), (float)pScale, (Vector3f)ANIMATION_VECTOR_CACHE));
    }

    protected void m_233381_(AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks) {
        this.m_233385_(pAnimationState, pAnimationDefinition, pAgeInTicks, 1.0f);
    }

    protected void m_267799_(AnimationDefinition pAnimationDefinition, float pLimbSwing, float pLimbSwingAmount, float pMaxAnimationSpeed, float pAnimationScaleFactor) {
        if (pLimbSwing != 0.0f && pLimbSwingAmount != 0.0f) {
            long i = (long)(pLimbSwing * 50.0f * pMaxAnimationSpeed);
            float f = Math.min(pLimbSwingAmount * pAnimationScaleFactor, 1.0f);
            KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)pAnimationDefinition, (long)i, (float)f, (Vector3f)ANIMATION_VECTOR_CACHE);
        }
    }

    protected void m_233385_(AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks, float pSpeed) {
        pAnimationState.m_216974_(pAgeInTicks, pSpeed);
        pAnimationState.m_216979_(p_233392_ -> KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)pAnimationDefinition, (long)p_233392_.m_216981_(), (float)1.0f, (Vector3f)ANIMATION_VECTOR_CACHE));
    }

    protected void m_288214_(AnimationDefinition pAnimationDefinition) {
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)pAnimationDefinition, (long)0L, (float)1.0f, (Vector3f)ANIMATION_VECTOR_CACHE);
    }
}

