/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.fintastic.client.animation.CoelacanthAnims;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.common.entity.custom.Coelacanth;

public class CoelacanthModel<T extends Coelacanth>
extends FintasticModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart backbody;
    private final ModelPart tail;
    private final ModelPart analfin;
    private final ModelPart tailfin;
    private final ModelPart pelvicfinright;
    private final ModelPart adiposefin;
    private final ModelPart pelvicfinleft;
    private final ModelPart head;
    private final ModelPart leftfin;
    private final ModelPart rightfin;
    private final ModelPart dorsalfin;

    public CoelacanthModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.backbody = this.body.m_171324_("backbody");
        this.tail = this.backbody.m_171324_("tail");
        this.analfin = this.tail.m_171324_("analfin");
        this.tailfin = this.tail.m_171324_("tailfin");
        this.pelvicfinright = this.backbody.m_171324_("pelvicfinright");
        this.adiposefin = this.backbody.m_171324_("adiposefin");
        this.pelvicfinleft = this.backbody.m_171324_("pelvicfinleft");
        this.head = this.body.m_171324_("head");
        this.leftfin = this.head.m_171324_("leftfin");
        this.rightfin = this.head.m_171324_("rightfin");
        this.dorsalfin = this.head.m_171324_("dorsalfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-13.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition backbody = body.m_171599_("backbody", CubeListBuilder.m_171558_().m_171514_(31, 27).m_171488_(-2.5f, -5.0f, -0.5f, 5.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)12.5f));
        PartDefinition tail = backbody.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)10.5f));
        PartDefinition analfin = tail.m_171599_("analfin", CubeListBuilder.m_171558_().m_171514_(50, 51).m_171488_(0.0f, -0.5f, -1.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.5f, (float)2.5f, (float)1.0f));
        PartDefinition tailfin = tail.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(0.0f, -6.0f, 0.0f, 0.0f, 12.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition pelvicfinright = backbody.m_171599_("pelvicfinright", CubeListBuilder.m_171558_().m_171514_(51, 52).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.5f, (float)5.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition adiposefin = backbody.m_171599_("adiposefin", CubeListBuilder.m_171558_().m_171514_(2, 52).m_171488_(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)8.5f));
        PartDefinition pelvicfinleft = backbody.m_171599_("pelvicfinleft", CubeListBuilder.m_171558_().m_171514_(51, 45).m_171488_(0.0f, 0.0f, 2.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.5f, (float)5.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -6.0f, -15.0f, 7.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)11.0f));
        PartDefinition leftfin = head.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(18, 49).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)3.6f, (float)3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition rightfin = head.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(18, 49).m_171488_(-1.0f, 0.0f, -1.0f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.5f, (float)3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition dorsalfin = head.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(34, 50).m_171488_(0.0f, -7.0f, -1.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Coelacanth pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (this.f_102610_) {
            this.m_288214_(CoelacanthAnims.BABY);
        }
        this.animateIdle(pEntity.idleAnimationState, CoelacanthAnims.IDLE, pAgeInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount)));
        this.animateIdle(pEntity.flopAnimationState, CoelacanthAnims.FLOP, pAgeInTicks, 1.0f, (float)pEntity.getTicksOutsideWater() / 3.0f);
        if (pEntity.m_20072_()) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180) / 32.0f;
            this.body.f_104203_ = -(headPitch * ((float)Math.PI / 180) / 32.0f);
            this.backbody.f_104203_ = -(headPitch * ((float)Math.PI / 180) / 16.0f);
            this.head.f_104204_ = pEntity.currentRoll / 2.0f;
            this.body.f_104204_ = pEntity.currentRoll / 4.0f;
            this.backbody.f_104204_ = -pEntity.currentRoll / 2.0f;
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180) / 2.0f;
            this.swim_rot.f_104205_ = -netHeadYaw * ((float)Math.PI / 360);
            this.m_267799_(CoelacanthAnims.SWIM, pLimbSwing * 3.0f, pLimbSwingAmount * 5.0f, 2.0f, 3.0f);
        } else {
            this.swim_rot.m_233569_();
            this.head.m_233569_();
            this.backbody.m_233569_();
            this.body.m_233569_();
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

