/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.interpolation;

import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class EndimationEasers {
    public static final BasicRegistry<Function<Float, Float>> REGISTRY = new BasicRegistry();
    public static final Function<Float, Float> LINEAR = EndimationEasers.register("linear", Function.identity());
    public static final Function<Float, Float> EASE_IN_SINE = EndimationEasers.register("ease_in_sine", (Float progress) -> Float.valueOf(1.0f - (float)Math.cos(1.5707964f * progress.floatValue())));
    public static final Function<Float, Float> EASE_OUT_SINE = EndimationEasers.register("ease_out_sine", (Float progress) -> Float.valueOf((float)Math.sin(1.5707964f * progress.floatValue())));
    public static final Function<Float, Float> EASE_IN_OUT_SINE = EndimationEasers.register("ease_in_out_sine", (Float progress) -> Float.valueOf((float)((-Math.cos((float)Math.PI * progress.floatValue()) + 1.0) * 0.5)));
    public static final Function<Float, Float> EASE_IN_QUAD = EndimationEasers.register("ease_in_quad", (Float progress) -> Float.valueOf(progress.floatValue() * progress.floatValue()));
    public static final Function<Float, Float> EASE_OUT_QUAD = EndimationEasers.register("ease_out_quad", (Float progress) -> {
        float base = 1.0f - progress.floatValue();
        return Float.valueOf(1.0f - base * base);
    });
    public static final Function<Float, Float> EASE_IN_OUT_QUAD = EndimationEasers.register("ease_in_out_quad", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf(2.0f * progress.floatValue() * progress.floatValue());
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf(1.0f - base * base * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_CUBIC = EndimationEasers.register("ease_in_cubic", (Float progress) -> Float.valueOf(progress.floatValue() * progress.floatValue() * progress.floatValue()));
    public static final Function<Float, Float> EASE_OUT_CUBIC = EndimationEasers.register("ease_out_cubic", (Float progress) -> {
        float base = 1.0f - progress.floatValue();
        return Float.valueOf(1.0f - base * base * base);
    });
    public static final Function<Float, Float> EASE_IN_OUT_CUBIC = EndimationEasers.register("ease_in_out_cubic", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf(4.0f * progress.floatValue() * progress.floatValue() * progress.floatValue());
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf(1.0f - base * base * base * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_QUART = EndimationEasers.register("ease_in_quart", (Float progress) -> Float.valueOf(progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue()));
    public static final Function<Float, Float> EASE_OUT_QUART = EndimationEasers.register("ease_out_quart", (Float progress) -> {
        float base = 1.0f - progress.floatValue();
        return Float.valueOf(1.0f - base * base * base * base);
    });
    public static final Function<Float, Float> EASE_IN_OUT_QUART = EndimationEasers.register("ease_in_out_quart", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf(8.0f * progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue());
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf(1.0f - base * base * base * base * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_QUINT = EndimationEasers.register("ease_in_quint", (Float progress) -> Float.valueOf(progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue()));
    public static final Function<Float, Float> EASE_OUT_QUINT = EndimationEasers.register("ease_out_quint", (Float progress) -> {
        float base = 1.0f - progress.floatValue();
        return Float.valueOf(1.0f - base * base * base * base * base);
    });
    public static final Function<Float, Float> EASE_IN_OUT_QUINT = EndimationEasers.register("ease_in_out_quint", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf(16.0f * progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue() * progress.floatValue());
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf(1.0f - base * base * base * base * base * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_EXPO = EndimationEasers.register("ease_in_expo", (Float progress) -> Float.valueOf(progress.floatValue() == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * progress.floatValue() - 10.0f)));
    public static final Function<Float, Float> EASE_OUT_EXPO = EndimationEasers.register("ease_out_expo", (Float progress) -> Float.valueOf(progress.floatValue() == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * progress.floatValue())));
    public static final Function<Float, Float> EASE_IN_OUT_EXPO = EndimationEasers.register("ease_in_out_expo", (Float progress) -> {
        if (progress.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        if (progress.floatValue() == 1.0f) {
            return Float.valueOf(1.0f);
        }
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf((float)Math.pow(2.0, 20.0f * progress.floatValue() - 10.0f) * 0.5f);
        }
        return Float.valueOf((float)(2.0 - Math.pow(2.0, -20.0f * progress.floatValue() + 10.0f)) * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_CIRC = EndimationEasers.register("ease_in_circ", (Float progress) -> Float.valueOf((float)(1.0 - Math.sqrt(1.0f - progress.floatValue() * progress.floatValue()))));
    public static final Function<Float, Float> EASE_OUT_CIRC = EndimationEasers.register("ease_out_circ", (Float progress) -> {
        float base = progress.floatValue() - 1.0f;
        return Float.valueOf((float)Math.sqrt(1.0f - base * base));
    });
    public static final Function<Float, Float> EASE_IN_OUT_CIRC = EndimationEasers.register("ease_in_out_circ", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            float base = 2.0f * progress.floatValue();
            return Float.valueOf((float)((1.0 - Math.sqrt(1.0f - base * base)) * 0.5));
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf((float)(Math.sqrt(1.0f - base * base) + 1.0) * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_BACK = EndimationEasers.register("ease_in_back", (Float progress) -> {
        float bounce = 1.70158f;
        float base = bounce + 1.0f;
        return Float.valueOf(base * progress.floatValue() * progress.floatValue() * progress.floatValue() - bounce * progress.floatValue() * progress.floatValue());
    });
    public static final Function<Float, Float> EASE_OUT_BACK = EndimationEasers.register("ease_out_back", (Float progress) -> {
        float bounce = 1.70158f;
        float base = bounce + 1.0f;
        float base2 = progress.floatValue() - 1.0f;
        return Float.valueOf(1.0f + base * base2 * base2 * base2 + bounce * base2 * base2);
    });
    public static final Function<Float, Float> EASE_IN_OUT_BACK = EndimationEasers.register("ease_in_out_back", (Float progress) -> {
        float bounce = 1.70158f;
        float base = bounce * 1.525f;
        if (progress.floatValue() < 0.5f) {
            float base2 = 2.0f * progress.floatValue();
            return Float.valueOf(base2 * base2 * ((base + 1.0f) * 2.0f * progress.floatValue() - base) * 0.5f);
        }
        float base2 = 2.0f * progress.floatValue() - 2.0f;
        return Float.valueOf((base2 * base2 * ((base + 1.0f) * (progress.floatValue() * 2.0f - 2.0f) + base2) + 2.0f) * 0.5f);
    });
    public static final Function<Float, Float> EASE_IN_ELASTIC = EndimationEasers.register("ease_in_elastic", (Float progress) -> {
        float base = 2.0943952f;
        if (progress.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        if (progress.floatValue() == 1.0f) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)(-Math.pow(2.0, 10.0f * progress.floatValue() - 10.0f) * Math.sin((progress.floatValue() * 10.0f - 10.75f) * base)));
    });
    public static final Function<Float, Float> EASE_OUT_ELASTIC = EndimationEasers.register("ease_out_elastic", (Float progress) -> {
        float base = 2.0943952f;
        if (progress.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        if (progress.floatValue() == 1.0f) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)(-Math.pow(2.0, -10.0f * progress.floatValue()) * Math.sin((progress.floatValue() * 10.0f - 0.75f) * base) + 1.0));
    });
    public static final Function<Float, Float> EASE_IN_OUT_ELASTIC = EndimationEasers.register("ease_in_out_elastic", (Float progress) -> {
        float base = 1.3962635f;
        if (progress.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        if (progress.floatValue() == 1.0f) {
            return Float.valueOf(1.0f);
        }
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf((float)(-(Math.pow(2.0, 20.0f * progress.floatValue() - 10.0f) * Math.sin((20.0f * progress.floatValue() - 11.125f) * base)) * 0.5));
        }
        return Float.valueOf((float)(Math.pow(2.0, -20.0f * progress.floatValue() + 10.0f) * Math.sin((20.0f * progress.floatValue() - 11.125f) * base) * 0.5 + 1.0));
    });
    public static final Function<Float, Float> EASE_IN_BOUNCE = EndimationEasers.register("ease_in_bounce", (Float progress) -> Float.valueOf(1.0f - EndimationEasers.bounce(1.0f - progress.floatValue())));
    public static final Function<Float, Float> EASE_OUT_BOUNCE = EndimationEasers.register("ease_out_bounce", EndimationEasers::bounce);
    public static final Function<Float, Float> EASE_IN_OUT_BOUNCE = EndimationEasers.register("ease_in_out_bounce", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf((1.0f - EndimationEasers.bounce(1.0f - 2.0f * progress.floatValue())) * 0.5f);
        }
        return Float.valueOf((1.0f + EndimationEasers.bounce(2.0f * progress.floatValue() - 1.0f)) * 0.5f);
    });

    private EndimationEasers() {
    }

    private static float bounce(float progress) {
        float base1 = 7.5625f;
        float base2 = 2.75f;
        if (progress < 1.0f / base2) {
            return base1 * progress * progress;
        }
        if (progress < 2.0f / base2) {
            return base1 * (progress -= 1.5f / base2) * progress + 0.75f;
        }
        if (progress < 2.5f / base2) {
            return base1 * (progress -= 2.25f / base2) * progress + 0.9375f;
        }
        return base1 * (progress -= 2.625f / base2) * progress + 0.984375f;
    }

    private static Function<Float, Float> register(String name, Function<Float, Float> easer) {
        REGISTRY.register(name, easer);
        return easer;
    }

    public static synchronized Function<Float, Float> register(ResourceLocation name, Function<Float, Float> easer) {
        REGISTRY.register(name, easer);
        return easer;
    }
}

