/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.client;

import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public abstract class BlueprintLanguageProvider
extends LanguageProvider {
    public final String modid;

    public BlueprintLanguageProvider(PackOutput output, String modid) {
        super(output, modid, "en_us");
        this.modid = modid;
    }

    public void add(Block ... blocks) {
        List.of(blocks).forEach(block -> this.add((Block)block, this.format(ForgeRegistries.BLOCKS.getKey(block))));
    }

    public void addStorageBlock(Block ... blocks) {
        List.of(blocks).forEach(block -> this.add((Block)block, "Block of " + this.format(ForgeRegistries.BLOCKS.getKey(block)).replace(" Block", "")));
    }

    public void add(Item ... items) {
        List.of(items).forEach(item -> this.add((Item)item, this.format(ForgeRegistries.ITEMS.getKey(item))));
    }

    public void addMusicDisc(Item item, String description) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, "Music Disc");
            this.add(item.m_5524_() + ".desc", description);
        }
    }

    public void addEnchantment(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, this.format(name));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    public void addCurse(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, "Curse of " + this.format(name.replace("_curse", "")));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    public void addDamageType(String suffix, String value) {
        this.add("death.attack." + this.modid + "." + suffix, value);
    }

    public String format(ResourceLocation name) {
        return this.format(name.m_135815_());
    }

    public String format(String path) {
        return WordUtils.capitalizeFully((String)path.replace("_", " ")).replace(" Of ", " of ");
    }
}

