/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSource;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;

public final class ModdedBiomeSlicesManager {
    public static void onServerAboutToStart(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Set slices = registryAccess.m_175515_(BlueprintDataPackRegistries.MODDED_BIOME_SLICES).m_6579_();
        if (slices.isEmpty()) {
            return;
        }
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        Holder.Reference originalSourceMarker = biomeRegistry.m_246971_(BlueprintBiomes.ORIGINAL_SOURCE_MARKER);
        HashMap assignedSlices = new HashMap();
        for (Map.Entry unassignedSlice : slices) {
            Set<Holder<Biome>> additionalPossibleBiomes;
            BiomeUtil.ModdedBiomeProvider provider;
            ModdedBiomeSlice slice = (ModdedBiomeSlice)unassignedSlice.getValue();
            if (slice.weight() <= 0 || (provider = slice.provider()) != BiomeUtil.OriginalModdedBiomeProvider.INSTANCE && ((additionalPossibleBiomes = provider.getAdditionalPossibleBiomes((Registry<Biome>)biomeRegistry)).isEmpty() || additionalPossibleBiomes.size() == 1 && additionalPossibleBiomes.contains(originalSourceMarker))) continue;
            slice.levels().forEach(levelStemResourceKey -> assignedSlices.computeIfAbsent(levelStemResourceKey.m_135782_(), __ -> new ArrayList()).add(Pair.of((Object)((ResourceKey)unassignedSlice.getKey()).m_135782_(), (Object)slice)));
        }
        CommentedConfig moddedBiomeSliceSizes = (CommentedConfig)BlueprintConfig.COMMON.moddedBiomeSliceSizes.get();
        int defaultSize = moddedBiomeSliceSizes.getIntOrElse("default", 9);
        if (defaultSize <= 0) {
            Blueprint.LOGGER.warn("Found a non-positive value for the default slice size! Slice size 9 will be used instead.");
            defaultSize = 9;
        }
        Registry dimensions = registryAccess.m_175515_(Registries.f_256862_);
        long seed = server.m_129910_().m_246337_().m_245499_();
        for (Map.Entry entry : dimensions.m_6579_()) {
            ChunkGenerator chunkGenerator;
            BiomeSource source;
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            ArrayList slicesForKey = (ArrayList)assignedSlices.get(location);
            if (slicesForKey == null || slicesForKey.isEmpty() || (source = (chunkGenerator = ((LevelStem)entry.getValue()).f_63976_()).m_62218_()) instanceof FixedBiomeSource || source instanceof CheckerboardColumnBiomeSource) continue;
            int size = moddedBiomeSliceSizes.getIntOrElse(location.toString(), defaultSize);
            if (size <= 0) {
                size = defaultSize;
            }
            ModdedBiomeSource moddedBiomeSource = new ModdedBiomeSource((Registry<Biome>)biomeRegistry, source, slicesForKey, size, seed, location.hashCode());
            chunkGenerator.f_62137_ = moddedBiomeSource;
            chunkGenerator.f_223020_ = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(moddedBiomeSource.m_207840_()), biomeHolder -> chunkGenerator.m_223131_(biomeHolder).m_47818_(), (boolean)true));
        }
    }
}

