/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;

public class SplashRippleParticle
extends FlatPlaneParticle {
    private final BlockPos.MutableBlockPos pos;
    private final SpriteSet sprites;
    private final TagKey<Fluid> fluidTag;
    private final boolean glowing;
    private boolean shouldAnimate = false;

    protected SplashRippleParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, float xScale, TagKey<Fluid> fluidTag, boolean glowing) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.fluidTag = fluidTag;
        this.glowing = glowing;
        this.pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_122032_();
        this.rotation = this.rotation.rotateX(1.5707964f);
        this.f_107225_ = 15;
        xScale /= 2.0f;
        xScale -= xScale * 0.0625f * 4.0f;
        this.f_107663_ = xScale;
        this.m_107250_(xScale, 0.1f);
        this.m_108339_(sprites);
    }

    public void m_5989_() {
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (!this.f_107208_.m_6425_((BlockPos)this.pos).m_205070_(this.fluidTag) && !Util.getCauldronFluid(this.f_107208_.m_8055_((BlockPos)this.pos)).m_205067_(this.fluidTag)) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            if (this.shouldAnimate) {
                this.m_107274_();
                return;
            }
            this.shouldAnimate = true;
            this.f_107225_ = 20;
            this.f_107224_ = 0;
        }
        this.f_107663_ += 0.005f;
        if (this.shouldAnimate) {
            this.m_108339_(this.sprites);
        }
    }

    protected int m_6355_(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.m_6355_(partialTick);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (TagKey<Fluid>)FluidTags.f_13132_, true);
            if (((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() == 0.0f) {
                particle.m_107271_(0.0f);
            }
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (TagKey<Fluid>)FluidTags.f_13131_, false);
            int waterColor = ((Biome)level.m_204166_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_203334_()).m_47560_();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.m_107253_(whiteIntensity + colorIntensity * ((float)(waterColor >> 16 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor >> 8 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor & 0xFF) / 255.0f));
            }
            particle.m_107271_(((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue());
            return particle;
        }
    }
}

