/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.ModelParticle;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class SplashParticle
extends ModelParticle {
    private final boolean glowing;
    private final TagKey<Fluid> fluidTag;
    private final SpriteSet sprites;
    @Nullable
    private final SpriteSet overlaySprites;
    private final boolean hasOverlay;
    private final BlockPos.MutableBlockPos pos;
    private float xScale;
    private final float yScale;
    private ResourceLocation texture;
    private ResourceLocation overlayTexture;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;
    private final SplashParticleModel model = this.bakeModel(SplashParticleModel::new, SplashParticleModel.MODEL_LAYER);

    protected SplashParticle(ClientLevel level, double x, double y, double z, boolean glowing, TagKey<Fluid> fluidTag, SpriteSet sprites, @Nullable SpriteSet overlaySprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.sprites = sprites;
        this.overlaySprites = overlaySprites;
        this.pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_122032_();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.f_107225_ = 15;
        this.xScale = options.xScale();
        this.yScale = options.yScale();
        this.m_107250_(this.xScale, this.yScale);
        this.setSpriteFromAge();
    }

    protected int m_6355_(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (!this.f_107208_.m_6425_((BlockPos)this.pos).m_205070_(this.fluidTag) && !Util.getCauldronFluid(this.f_107208_.m_8055_((BlockPos)this.pos)).m_205067_(this.fluidTag)) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.xScale += 0.01333f;
        this.setSpriteFromAge();
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer consumer, MultiBufferSource.BufferSource bufferSource, Camera camera, float partialTicks) {
        int lightColor = this.m_6355_(partialTicks);
        poseStack.m_252880_(0.0f, -(6.0f * (this.yScale / 4.0f)), 0.0f);
        poseStack.m_85841_(this.xScale, this.yScale, this.xScale);
        this.model.m_7695_(poseStack, bufferSource.m_6299_(this.model.m_103119_(this.texture)), lightColor, OverlayTexture.f_118083_, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
        if (this.hasOverlay) {
            this.model.m_7695_(poseStack, bufferSource.m_6299_(this.model.m_103119_(this.overlayTexture)), lightColor, OverlayTexture.f_118083_, this.overlayRCol, this.overlayGCol, this.overlayBCol, ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue());
        }
        bufferSource.m_109911_();
    }

    private void setSpriteFromAge() {
        this.texture = this.getSpriteId(this.sprites.m_5819_(this.f_107224_, this.f_107225_));
        if (this.hasOverlay) {
            this.overlayTexture = this.getSpriteId(this.overlaySprites.m_5819_(this.f_107224_, this.f_107225_));
        }
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashParticle(level, x, y, z, true, (TagKey<Fluid>)FluidTags.f_13132_, this.sprites, null, options);
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashParticle particle = new SplashParticle(level, x, y, z, false, (TagKey<Fluid>)FluidTags.f_13131_, this.sprites, (SpriteSet)ModSpriteSets.WATER_SPLASH_OVERLAY, options);
            int waterColor = ((Biome)level.m_204166_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_203334_()).m_47560_();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.m_107253_(red, green, blue);
            return particle;
        }
    }
}

