/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FallenLeafParticleOptions;
import einstein.subtle_effects.util.LifetimeAlpha;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FallenLeafParticle
extends FlatPlaneParticle {
    private final LifetimeAlpha lifetimeAlpha;

    protected FallenLeafParticle(ClientLevel level, double x, double y, double z, double xSpeed, double zSpeed, FallenLeafParticleOptions options) {
        super(level, x, y, z);
        if (!options.onGround() && ModConfigs.GENERAL.leavesLandingOnWaterKeepMomentum) {
            this.f_107215_ = MathUtil.nextDouble(this.f_107223_, xSpeed / 4.0 * 3.0);
            this.f_107217_ = MathUtil.nextDouble(this.f_107223_, zSpeed / 4.0 * 3.0);
        }
        int baseLifetime = (Integer)ModConfigs.GENERAL.fallenLeavesLifeTime.get();
        this.f_107225_ = baseLifetime + this.f_107223_.m_188503_(10) * MathUtil.nextSign(this.f_107223_);
        this.lifetimeAlpha = new LifetimeAlpha(options.alpha(), 0.0f, 0.5f, 1.0f);
        this.f_107230_ = this.lifetimeAlpha.startAlpha();
        this.rotation = this.rotation.rotateX(1.5707964f);
        this.f_172258_ = 0.96f;
        this.f_108321_ = options.sprite();
        this.f_107204_ = this.f_107231_ = options.rotation();
        this.f_107663_ = options.quadSize();
        this.m_107250_(options.bbWidth(), options.bbHeight());
        Vector3f color = options.color();
        this.m_107253_(color.x, color.y, color.z);
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.m_5744_(buffer, renderInfo, partialTicks);
        this.f_107230_ = this.lifetimeAlpha.currentAlphaForAge(this.f_107224_, this.f_107225_, partialTicks);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider() implements ParticleProvider<FallenLeafParticleOptions>
    {
        @Nullable
        public Particle createParticle(FallenLeafParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return options == FallenLeafParticleOptions.EMPTY ? null : new FallenLeafParticle(level, x, y, z, xSpeed, zSpeed, options);
        }
    }
}

