/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModAnimalFedEffectSettings {
    private static final Map<EntityType<?>, Settings> REGISTERED = new HashMap();
    public static final Settings DEFAULT_VALUE = new Settings(Vec3.f_82478_, null, stack -> stack);

    public static void init() {
        REGISTERED.clear();
        if (((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue() == 0.0f && !ModConfigs.ENTITIES.animalFeedingParticles) {
            return;
        }
        ModAnimalFedEffectSettings.register(EntityType.f_20557_, ModSounds.COW_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20504_, SoundEvents.f_12072_);
        ModAnimalFedEffectSettings.register(EntityType.f_20555_, 0.3, -0.7, ModSounds.CHICKEN_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20553_, 0.0, -0.4, SoundEvents.f_11788_);
        ModAnimalFedEffectSettings.register(EntityType.f_20505_, 0.0, -0.3, ModSounds.OCELOT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20507_, -0.35, 0.3, SoundEvents.f_12181_);
        ModAnimalFedEffectSettings.register(EntityType.f_20520_, 0.0, -0.2, ModSounds.SHEEP_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20508_, 0.2, -0.9, SoundEvents.f_12190_);
        ModAnimalFedEffectSettings.register(EntityType.f_147039_, new Vec3(0.0, 0.0, -0.4), ModSounds.AXOLOTL_EAT, stack -> stack.m_150930_(Items.f_42459_) ? new ItemStack((ItemLike)Items.f_42528_) : stack);
        ModAnimalFedEffectSettings.register(EntityType.f_243976_, 1.0, 0.6);
        ModAnimalFedEffectSettings.register(EntityType.f_20550_, 0.0, -0.7, ModSounds.BEE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_217012_, 0.0, -0.7, SoundEvents.f_215692_);
        ModAnimalFedEffectSettings.register(EntityType.f_20559_, 0.0, -0.2, SoundEvents.f_11803_);
        ModAnimalFedEffectSettings.register(EntityType.f_217013_, 0.0, -0.9, ModSounds.TADPOLE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20452_, 0.0, -0.6);
        ModAnimalFedEffectSettings.register(EntityType.f_20466_, 0.4, -0.1);
        ModAnimalFedEffectSettings.register(EntityType.f_20488_, 0.4, -0.1);
        ModAnimalFedEffectSettings.register(EntityType.f_20517_, 0.0, -0.8, ModSounds.RABBIT_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_271264_, 0.0, 1.5);
        ModAnimalFedEffectSettings.register(EntityType.f_20503_, 0.0, 0.2);
        ModAnimalFedEffectSettings.register(EntityType.f_20560_, 0.0, 0.2);
        ModAnimalFedEffectSettings.register(EntityType.f_20457_, 0.2, 0.4);
        ModAnimalFedEffectSettings.register(EntityType.f_20482_, 0.0, -0.6);
        ModAnimalFedEffectSettings.register(EntityType.f_20499_, 0.0, -0.3);
        ModAnimalFedEffectSettings.register(EntityType.f_20490_, ModSounds.TURTLE_EAT);
        ModAnimalFedEffectSettings.register(EntityType.f_20456_, ModSounds.HOGLIN_EAT);
    }

    public static void register(EntityType<?> type, double y, double z) {
        ModAnimalFedEffectSettings.register(type, y, z, (Supplier<SoundEvent>)null);
    }

    public static void register(EntityType<?> type, double y, double z, @Nullable SoundEvent sound) {
        ModAnimalFedEffectSettings.register(type, y, z, () -> sound);
    }

    public static void register(EntityType<?> type, double y, double z, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, new Vec3(0.0, y, z), sound);
    }

    public static void register(EntityType<?> type, @Nullable SoundEvent sound) {
        ModAnimalFedEffectSettings.register(type, Vec3.f_82478_, () -> sound);
    }

    public static void register(EntityType<?> type, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, Vec3.f_82478_, sound);
    }

    public static void register(EntityType<?> type, Vec3 offset, @Nullable Supplier<SoundEvent> sound) {
        ModAnimalFedEffectSettings.register(type, offset, sound, stack -> stack);
    }

    public static void register(EntityType<?> type, Vec3 offset, @Nullable Supplier<SoundEvent> sound, UnaryOperator<ItemStack> stackReplacer) {
        if (REGISTERED.put(type, new Settings(offset, sound, stackReplacer)) != null) {
            SubtleEffects.LOGGER.error("Attempted to register multiple feeding effect overrides to entity: \"{}\"", (Object)BuiltInRegistries.f_256780_.m_7981_(type));
        }
    }

    public static Settings getSetting(EntityType<?> type) {
        return REGISTERED.getOrDefault(type, DEFAULT_VALUE);
    }

    public record Settings(Vec3 offset, @Nullable Supplier<SoundEvent> sound, UnaryOperator<ItemStack> stackReplacer) {
    }
}

