/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.compat;

import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.itemborders.ItemBordersConfig;
import com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.datafixers.util.Pair;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.mixin.client.ItemBordersConfigAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;

public class ItemBordersCompat {
    private static final String ITEM_BORDERS_COLORS_TAG = "itemborders_colors";

    public static TextColor getManualBorderColor(ItemStack stack) {
        Map manualBorders = ((UnmodifiableConfig)((ItemBordersConfigAccessor)ItemBordersConfigAccessor.getInstance()).getManualBorders().get()).valueMap();
        for (String colorString : manualBorders.keySet()) {
            TextColor color = ItemBordersConfig.getColor((Object)colorString);
            if (color == null) continue;
            Object object = manualBorders.get(colorString);
            if (ItemBordersCompat.matchesStack(stack, object)) {
                return color;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object obj : list) {
                if (!ItemBordersCompat.matchesStack(stack, obj)) continue;
                return color;
            }
        }
        return null;
    }

    private static boolean matchesStack(ItemStack stack, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return Selectors.itemMatches((ItemStack)stack, (String)string);
        }
        return false;
    }

    public static List<TextColor> getNBTBorderColor(ItemStack stack) {
        Pair borderColors;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128441_(ITEM_BORDERS_COLORS_TAG)) {
            CompoundTag colorsTag = tag.m_128469_(ITEM_BORDERS_COLORS_TAG);
            ArrayList<TextColor> colors = new ArrayList<TextColor>();
            if (colorsTag.m_128425_("top", 8)) {
                colors.add(ItemBordersConfig.getColor((Object)colorsTag.m_128461_("top")));
            }
            if (colorsTag.m_128425_("bottom", 8)) {
                colors.add(ItemBordersConfig.getColor((Object)colorsTag.m_128461_("bottom")));
            }
            return colors.stream().filter(Objects::nonNull).toList();
        }
        if (CompatHelper.IS_LEGENDARY_TOOLTIPS_LOADED.get().booleanValue() && ((Boolean)ItemBordersConfigAccessor.getInstance().legendaryTooltipsSync.get()).booleanValue() && (borderColors = LegendaryTooltipsHandler.getBorderColors((ItemStack)stack)) != null) {
            ArrayList<TextColor> colors = new ArrayList<TextColor>();
            colors.add(TextColor.m_131266_((int)((Integer)((Supplier)borderColors.getFirst()).get())));
            colors.add(TextColor.m_131266_((int)((Integer)((Supplier)borderColors.getSecond()).get())));
            return colors;
        }
        return List.of();
    }
}

