/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemArmorLayer;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemRenderLayerParentImpl;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.joml.Vector3f;

public class EinsteinSolarSystemLayer<T extends AbstractClientPlayer, V extends PlayerModel<T>>
extends RenderLayer<T, V> {
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final EinsteinSolarSystemRenderLayerParentImpl<T, V> renderLayerParent;
    private final EinsteinSolarSystemModel<T> model;
    private final CustomHeadLayer<T, EinsteinSolarSystemModel<T>> headLayer;
    private final EinsteinSolarSystemArmorLayer<T, EinsteinSolarSystemModel<T>, HumanoidModel<T>> armorLayer;
    private final PartyHatLayer<T, EinsteinSolarSystemModel<T>> partyHatLayer;

    public EinsteinSolarSystemLayer(RenderLayerParent<T, V> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.model = new EinsteinSolarSystemModel(context.m_174023_(EinsteinSolarSystemModel.MODEL_LAYER));
        this.renderLayerParent = new EinsteinSolarSystemRenderLayerParentImpl(this);
        this.headLayer = new CustomHeadLayer(this.renderLayerParent, context.m_174027_(), context.m_234598_());
        this.armorLayer = new EinsteinSolarSystemArmorLayer<T, V, HumanoidArmorModel>(this.renderLayerParent, new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_());
        if (PartyHatLayer.isModBirthday(false)) {
            this.partyHatLayer = new PartyHatLayer<T, V>(this.renderLayerParent, context);
            return;
        }
        this.partyHatLayer = null;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EinsteinSolarSystemLayer.shouldRender(player)) {
            int headCount = HEAD_ROTATIONS.length;
            this.model.f_102809_.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
            for (int i = 0; i < headCount; ++i) {
                float i1 = i + 1;
                float spin = EinsteinSolarSystemLayer.getSpin(partialTicks, player, i) * ((float)headCount / i1);
                Vector3f rotation = HEAD_ROTATIONS[i];
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f - Mth.m_14189_((float)partialTicks, (float)((AbstractClientPlayer)player).f_20884_, (float)((AbstractClientPlayer)player).f_20883_)));
                poseStack.m_252781_(Axis.f_252436_.m_252961_(spin));
                poseStack.m_85837_(0.7 * (double)i1, player.m_6047_() ? 0.0 : -0.25, 0.0);
                poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation.x()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation.y()));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation.z()));
                poseStack.m_252781_(Axis.f_252436_.m_252961_(spin));
                VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(player)));
                this.model.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_(player, (float)0.0f), 0.0f, 0.0f, 0.0f, 0.0f);
                poseStack.m_85837_(0.0, 0.25, 0.0);
                this.headLayer.m_6494_(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                this.armorLayer.m_6494_(poseStack, bufferSource, packedLight, (LivingEntity)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                if (this.partyHatLayer != null) {
                    this.partyHatLayer.render(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
        }
    }

    public ResourceLocation getTextureLocation(T player) {
        return super.m_117347_(player);
    }

    public EinsteinSolarSystemModel<T> getModel() {
        return this.model;
    }

    public EinsteinSolarSystemRenderLayerParentImpl<T, V> getRenderLayerParent() {
        return this.renderLayerParent;
    }

    public static boolean shouldRender(AbstractClientPlayer player) {
        return ModConfigs.GENERAL.enableEasterEggs && (Util.isMincraftEinstein(player) || Services.PLATFORM.isDevelopmentEnvironment()) && !player.m_20145_();
    }

    public static float getSpin(float partialTicks, AbstractClientPlayer player, float speed) {
        return ((float)player.f_19797_ + partialTicks) / 20.0f + (float)Math.PI * speed;
    }
}

