/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticleProviders;
import einstein.subtle_effects.init.ModParticleRenderTypes;
import einstein.subtle_effects.init.ModRenderTypes;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.ticking.tickers.ChestBlockEntityTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.WaterfallTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.Util;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static boolean HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = false;
    private static boolean DISPLAY_PARTICLE_BOUNDING_BOXES = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModRenderTypes.init();
        ModParticleRenderTypes.init();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticleProviders.init();
        ModSpriteSets.init();
        ModAnimalFedEffectSettings.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                SubtleEffectsClient.clear(level);
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.m_91104_()) {
            return;
        }
        if (!HAS_DISPLAYED_BIRTHDAY_NOTIFICATION && ModConfigs.GENERAL.enableEasterEggs && PartyHatLayer.isModBirthday(true)) {
            long years = ChronoUnit.YEARS.between(LocalDate.of(2024, Month.OCTOBER, 3), LocalDate.now());
            SubtleEffectsClient.sendSystemMsg((Player)player, (Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"chat.subtle_effects.prefix").m_130938_(style -> style.m_131140_(ChatFormatting.BLUE))).m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237110_((String)"chat.subtle_effects.anniversary.message", (Object[])new Object[]{Util.getOrdinal(years)})));
            HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = true;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.m_5661_((Component)Component.m_237110_((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.f_91061_.m_107403_()}), true);
        }
        ProfilerFiller profiler = minecraft.m_91307_();
        profiler.m_6180_("subtle_effects");
        profiler.m_6180_("biome_particles");
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        profiler.m_7238_();
        profiler.m_6180_("tickers");
        TickerManager.tick();
        profiler.m_7238_();
        HAS_CLEARED = false;
        profiler.m_7238_();
    }

    public static Map<ModelLayerLocation, Supplier<LayerDefinition>> registerModelLayers() {
        HashMap<ModelLayerLocation, Supplier<LayerDefinition>> layers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        layers.put(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer);
        layers.put(PartyHatModel.MODEL_LAYER, PartyHatModel::createLayer);
        layers.put(SplashParticleModel.MODEL_LAYER, SplashParticleModel::createLayer);
        return layers;
    }

    public static List<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> registerPlayerRenderLayers(PlayerRenderer renderer, EntityRendererProvider.Context context) {
        ArrayList<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> renderLayers = new ArrayList<RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>>();
        renderLayers.add(new EinsteinSolarSystemLayer(renderer, context));
        if (PartyHatLayer.isModBirthday(false)) {
            renderLayers.add(new PartyHatLayer(renderer, context));
        }
        return renderLayers;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1(minecraft, (Player)player, arg_0));
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$2((Player)player, arg_0));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$3((Player)player, arg_0))).then((ArgumentBuilder)particlesCountEnabled);
        RequiredArgumentBuilder particlesBoundingBoxesEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$4((Player)player, arg_0));
        LiteralArgumentBuilder particlesBoundingBoxes = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"display_bounding_boxes").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$5((Player)player, arg_0))).then((ArgumentBuilder)particlesBoundingBoxesEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount)).then((ArgumentBuilder)particlesBoundingBoxes);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$6(minecraft, (Player)player, arg_0));
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(Player player, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static int toggleParticleBoundingBoxes(Player player, boolean enabled) {
        DISPLAY_PARTICLE_BOUNDING_BOXES = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.display_bounding_boxes." + enabledString + ".success"));
        return 1;
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.m_237115_((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Player player, Component component) {
        if (player != null) {
            player.m_213846_(component);
        }
    }

    public static void clear(@Nullable Level level) {
        TickerManager.clear();
        EntityTickerManager.clear(level);
        GeyserManager.ACTIVE_GEYSERS.clear();
        GeyserManager.INACTIVE_GEYSERS.clear();
        WaterfallTicker.WATERFALLS.clear();
        ChestBlockEntityTicker.clear();
    }

    public static void renderParticleBoundingBoxes(PoseStack poseStack, Camera camera) {
        if (DISPLAY_PARTICLE_BOUNDING_BOXES) {
            poseStack.m_85836_();
            Minecraft minecraft = Minecraft.m_91087_();
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
            Vec3 cameraPos = camera.m_90583_();
            Frustum frustum = ((FrustumGetter)minecraft.f_91060_).subtleEffects$getCullingFrustum();
            float partialTicks = Util.getPartialTicks();
            ((ParticleEngineAccessor)minecraft.f_91061_).getParticles().forEach((renderType, particles) -> {
                if (particles == null || particles.isEmpty()) {
                    return;
                }
                int color = renderType.toString().hashCode();
                float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
                float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
                float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
                particles.forEach(particle -> {
                    AABB aabb = particle.m_107277_();
                    if (frustum.m_113029_(aabb)) {
                        poseStack.m_85836_();
                        ParticleAccessor accessor = (ParticleAccessor)particle;
                        double x = Mth.m_14139_((double)partialTicks, (double)accessor.getOldX(), (double)accessor.getX()) - cameraPos.m_7096_();
                        double y = Mth.m_14139_((double)partialTicks, (double)accessor.getOldY(), (double)accessor.getY()) - cameraPos.m_7098_();
                        double z = Mth.m_14139_((double)partialTicks, (double)accessor.getOldZ(), (double)accessor.getZ()) - cameraPos.m_7094_();
                        poseStack.m_85837_(x, y, z);
                        aabb = aabb.m_82386_(-accessor.getX(), -accessor.getY(), -accessor.getZ());
                        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        AABB renderTypeAABB = new AABB(aabb.f_82288_, aabb.f_82292_ - 0.02, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_ + 0.02, aabb.f_82293_);
                        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)renderTypeAABB, (float)red, (float)green, (float)blue, (float)1.0f);
                        poseStack.m_85849_();
                    }
                });
            });
            bufferSource.m_109912_(RenderType.m_110504_());
            poseStack.m_85849_();
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$6(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        SubtleEffectsClient.clear((Level)minecraft.f_91073_);
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$5(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleBoundingBoxes(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$4(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleBoundingBoxes(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$3(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$2(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        minecraft.f_91061_.m_263560_();
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
        return 1;
    }
}

