/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.mralxart.arcaneabilities.client.ABClient;
import it.mralxart.arcaneabilities.utils.ClientTickHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final RenderStateShard.TransparencyStateShard STATE = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderType STAR = RenderType.m_173215_((String)"dungeon_echo:star", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_173292_(new RenderStateShard.ShaderStateShard(ABClient::getStarShader)).m_110691_(false));
    public static RenderStateShard.TransparencyStateShard LIGHTNING_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static RenderType DRAGON_RAYS = RenderType.m_173215_((String)"dragon_rays", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172753_)).m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110685_(LIGHTNING_TRANSPARENCY).m_110691_(false));

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderUtils.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void render(PoseStack poseStack, MultiBufferSource buffer, int color, long seed) {
        float intensity = 0.5f;
        long seedModifier = 10L;
        float partialTicks = 0.0f;
        float scale = 1.0f;
        Random rng = new Random(432L + seedModifier);
        VertexConsumer vertexConsumer = buffer.m_6299_(DRAGON_RAYS);
        poseStack.m_85836_();
        float rotationSpeed = ((float)ClientTickHandler.ticksInGame + partialTicks) / 200.0f;
        float rootThreeDivTwo = (float)(Math.sqrt(3.0) / 2.0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int effectCount = (int)((intensity + intensity * intensity) / 2.0f * 60.0f);
        for (int j = 0; j < effectCount; ++j) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rng.nextFloat() * 360.0f + rotationSpeed * 90.0f));
            float lengthFactor = rng.nextFloat() * 20.0f + 5.0f;
            float widthFactor = rng.nextFloat() * 2.0f + 1.0f;
            Matrix4f transformation = poseStack.m_85850_().m_252922_();
            RenderUtils.drawVertices(vertexConsumer, transformation, r, g, b, 0.5f, rootThreeDivTwo, widthFactor *= 0.05f * scale, lengthFactor *= 0.05f * scale);
        }
        poseStack.m_85849_();
    }

    private static void drawVertices(VertexConsumer vertexConsumer, Matrix4f matrix, float red, float green, float blue, float alpha, float rootThreeDivTwo, float widthFactor, float lengthFactor) {
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, -rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, lengthFactor, widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, lengthFactor, widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
    }
}

