/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.utils;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class RelicsUtils {
    private static final ThreadLocal<ItemStack> CURRENT_STACK = new ThreadLocal();
    private static final ThreadLocal<Map<ItemStack, ItemStack>> STACKS_TO_SAVE = ThreadLocal.withInitial(HashMap::new);

    public static void putSaveStack(ItemStack combinedRelic, ItemStack saveStack) {
        STACKS_TO_SAVE.get().put(saveStack, combinedRelic);
    }

    public static void setCurrentStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        CURRENT_STACK.set(stack);
    }

    public static ItemStack getCurrentStack() {
        return CURRENT_STACK.get();
    }

    public static void saveAllChanges() {
        Map<ItemStack, ItemStack> map = STACKS_TO_SAVE.get();
        if (map.isEmpty()) {
            return;
        }
        map.forEach((child, real) -> {
            Item patt1976$temp = real.m_41720_();
            if (patt1976$temp instanceof CombinedRelicItem) {
                CombinedRelicItem combinedRelic = (CombinedRelicItem)patt1976$temp;
                if (child.m_41782_()) {
                    combinedRelic.updateFromChild((ItemStack)real, (ItemStack)child);
                }
            }
        });
        STACKS_TO_SAVE.get().clear();
    }

    public static void mixRelics(Player player, ItemStack relicStack1, ItemStack relicStack2) {
        ListTag parentIds;
        IRelicItem relic1;
        Item item;
        block14: {
            block13: {
                item = relicStack1.m_41720_();
                if (!(item instanceof IRelicItem)) break block13;
                relic1 = (IRelicItem)item;
                item = relicStack2.m_41720_();
                if (item instanceof IRelicItem) break block14;
            }
            return;
        }
        IRelicItem relic2 = (IRelicItem)item;
        if (relicStack1.m_41720_() == relicStack2.m_41720_()) {
            return;
        }
        if (relic1 instanceof CombinedRelicItem || relic2 instanceof CombinedRelicItem) {
            return;
        }
        RelicData data1 = relic1.constructDefaultRelicData();
        RelicData data2 = relic2.constructDefaultRelicData();
        if (data1 == null || data2 == null) {
            return;
        }
        ArrayList allAbilities = new ArrayList();
        allAbilities.addAll(data1.getAbilities().getAbilities().values());
        allAbilities.addAll(data2.getAbilities().getAbilities().values());
        CompoundTag abilityOrigins = new CompoundTag();
        ResourceLocation parent1Id = ForgeRegistries.ITEMS.getKey((Object)relicStack1.m_41720_());
        ResourceLocation parent2Id = ForgeRegistries.ITEMS.getKey((Object)relicStack2.m_41720_());
        data1.getAbilities().getAbilities().values().forEach(ability -> abilityOrigins.m_128359_(ability.getId(), parent1Id.toString()));
        data2.getAbilities().getAbilities().values().forEach(ability -> abilityOrigins.m_128359_(ability.getId(), parent2Id.toString()));
        Map<CastType, List<AbilityData>> typeListMap = allAbilities.stream().filter(a -> a.getCastData() != null).collect(Collectors.groupingBy(a -> a.getCastData().getType()));
        ListTag listTag = new ListTag();
        ListTag synergyList = new ListTag();
        Random random = new Random();
        for (List<AbilityData> group : typeListMap.values()) {
            ArrayList<AbilityData> abilityDataList = new ArrayList<AbilityData>(group);
            Collections.shuffle(abilityDataList, random);
            while (abilityDataList.size() >= 2) {
                AbilityData abilityData1 = (AbilityData)abilityDataList.remove(0);
                AbilityData abilityData2 = (AbilityData)abilityDataList.remove(0);
                CompoundTag synergyTag = new CompoundTag();
                String synergyId = "synergy_" + String.valueOf(UUID.randomUUID());
                synergyTag.m_128359_("SynergyID", synergyId);
                parentIds = new ListTag();
                parentIds.add((Object)StringTag.m_129297_((String)abilityData1.getId()));
                parentIds.add((Object)StringTag.m_129297_((String)abilityData2.getId()));
                synergyTag.m_128365_("ParentAbilities", (Tag)parentIds);
                String parentId1 = abilityData1.getId();
                synergyTag.m_128359_("parent1", parentId1);
                synergyList.add((Object)synergyTag);
                abilityOrigins.m_128359_(synergyId, abilityOrigins.m_128461_(parentId1));
            }
            if (abilityDataList.isEmpty()) continue;
            listTag.add((Object)StringTag.m_129297_((String)((AbilityData)abilityDataList.get(0)).getId()));
        }
        LevelingData leveling1 = data1.getLeveling();
        LevelingData leveling2 = data2.getLeveling();
        LevelingData resultLeveling = new LevelingData((leveling1.getInitialCost() + leveling2.getInitialCost()) / 2, Math.max(leveling1.getMaxLevel(), leveling2.getMaxLevel()), (leveling1.getStep() + leveling2.getStep()) / 2);
        ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.COMBINED_RELIC.get());
        CompoundTag tag = resultStack.m_41784_();
        tag.m_128365_("CombinedAbilities", (Tag)listTag);
        tag.m_128365_("Synergies", (Tag)synergyList);
        tag.m_128359_("Parent1", parent1Id.toString());
        tag.m_128359_("Parent2", parent2Id.toString());
        tag.m_128365_("AbilityOrigins", (Tag)abilityOrigins);
        CompoundTag levelingTag = new CompoundTag();
        levelingTag.m_128405_("cost", resultLeveling.getInitialCost());
        levelingTag.m_128405_("maxLvl", resultLeveling.getMaxLevel());
        levelingTag.m_128405_("step", resultLeveling.getStep());
        tag.m_128365_("CombinedLeveling", (Tag)levelingTag);
        parentIds = resultStack.m_41720_();
        if (parentIds instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)parentIds;
            Set<String> abilities = relicItem.getAbilities(resultStack);
            for (String abilityId : abilities) {
                AbilityData abilityData = AbilityRelicsData.get(abilityId).orElse(null);
                if (abilityData == null) continue;
                for (Map.Entry statEntry : abilityData.getStats().entrySet()) {
                    String statId = (String)statEntry.getKey();
                    StatData statData = (StatData)statEntry.getValue();
                    double key = (Double)statData.getInitialValue().getKey();
                    double value = (Double)statData.getInitialValue().getValue();
                    double minMax = (key + value) / 2.0;
                    double result = minMax + random.nextDouble() * (value - minMax);
                    result = MathUtils.round((double)result, (int)5);
                    ItemStack child = relicItem.createChildStack(resultStack, abilityId);
                    relicItem.setAbilityValue(child, abilityId, statId, result);
                    relicItem.saveChildStack(resultStack, abilityId, child);
                }
            }
            ArrayList<String> abilitiesList = new ArrayList<String>(abilities);
            if (!abilitiesList.isEmpty()) {
                String string = (String)abilitiesList.get(random.nextInt(abilitiesList.size()));
                ItemStack child = relicItem.createChildStack(resultStack, string);
                int points = relicItem.getAbilityPoints(child, string);
                relicItem.setAbilityPoints(child, string, points + 1);
                relicItem.saveChildStack(resultStack, string, child);
            }
        }
        relicStack1.m_41774_(1);
        relicStack2.m_41774_(1);
        if (!player.m_150109_().m_36054_(resultStack)) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), resultStack));
        }
    }
}

