/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.utils;

import it.hurts.sskirillss.relics.utils.MathUtils;
import it.mralxart.arcaneabilities.network.NetworkHandler;
import it.mralxart.arcaneabilities.network.messages.ParticleSpawnerPacket;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleUtils {
    public static void particleEntity(ParticleOptions particleOptions, Entity entity, int count, double maxSpeed) {
        ParticleUtils.particleAABB(entity.m_9236_(), particleOptions, entity.m_20191_(), count, maxSpeed);
    }

    public static void particleAABB(Level level, ParticleOptions particleOptions, AABB box, int count, double maxSpeed) {
        Vec3 center = box.m_82399_();
        double deltaX = box.m_82362_() / 2.0;
        double deltaY = box.m_82376_() / 2.0;
        double deltaZ = box.m_82385_() / 2.0;
        ParticleUtils.spawnParticles(level, particleOptions, center.f_82479_, center.f_82480_, center.f_82481_, count, deltaX, deltaY, deltaZ, maxSpeed);
    }

    public static void particleAABB(Level level, ParticleOptions particleOptions, AABB box, int count, double maxSpeed, double x, double y, double z) {
        double deltaX = box.m_82362_() / 2.0;
        double deltaY = box.m_82376_() / 2.0;
        double deltaZ = box.m_82385_() / 2.0;
        ParticleUtils.spawnParticles(level, particleOptions, x, y, z, count, deltaX, deltaY, deltaZ, maxSpeed);
    }

    public static void spawnParticleLine(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int particleCount, double speed) {
        Vec3 delta = end.m_82546_(start);
        Vec3 dir = delta.m_82541_();
        double len = delta.m_82553_();
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i * len / (double)particleCount;
            ParticleUtils.spawnParticles(level, particle, start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress, start.f_82481_ + dir.f_82481_ * progress, 1, 0.0, 0.0, 0.0, speed);
        }
    }

    public static void spawnParticles(Level level, ParticleOptions options, double x, double y, double z, int count, double dx, double dy, double dz, double maxSpeed) {
        RandomSource random = level.f_46441_;
        if (level.f_46443_) {
            for (int i = 0; i < count; ++i) {
                level.m_7106_(options, x + random.m_188500_() * dx, y + random.m_188500_() * dy, z + random.m_188500_() * dz, random.m_188500_() * maxSpeed, random.m_188500_() * maxSpeed, random.m_188500_() * maxSpeed);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                NetworkHandler.sendToAll(new ParticleSpawnerPacket(options, x + random.m_188500_() * dx, y + random.m_188500_() * dy, z + random.m_188500_() * dz, random.m_188500_() * maxSpeed, random.m_188500_() * maxSpeed, random.m_188500_() * maxSpeed));
            }
        }
    }

    public static void spawnCylLine(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int particleCount, double speed, float startRadius, float endRadius) {
        Vec3 delta = end.m_82546_(start);
        Vec3 dir = delta.m_82541_();
        double len = delta.m_82553_();
        float radius = startRadius;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i * len / (double)particleCount;
            if (radius < endRadius) {
                radius += 0.5f;
            }
            double posX = start.f_82479_ + dir.f_82479_ * progress;
            double posY = start.f_82480_ + dir.f_82480_ * progress;
            double posZ = start.f_82481_ + dir.f_82481_ * progress;
            ParticleUtils.spawnParticles(level, particle, posX, posY, posZ, 1, 0.0, 0.0, 0.0, speed);
            Vec3 pos = new Vec3(posX, posY, posZ);
            ParticleUtils.createCyl(particle, pos, level, radius, 1.0f);
        }
    }

    public static void createCyl(ParticleOptions particle, Vec3 center, Level level, double radius, float step) {
        int offset = 16;
        double len = Math.PI * 2 * radius;
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            double angle = Math.toRadians(360.0f / (float)num * (float)i);
            double extraX = radius * Math.sin(angle) + center.f_82479_;
            double extraZ = radius * Math.cos(angle) + center.f_82481_;
            double extraY = center.f_82480_ + 0.5;
            boolean foundPos = false;
            for (int tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(extraX, extraY, extraZ);
                BlockPos pos = BlockPos.m_274446_((Position)vec);
                BlockState state = level.m_8055_(pos);
                VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
                if (state.m_60734_() instanceof LiquidBlock) {
                    shape = Shapes.m_83144_();
                }
                if (shape.m_83281_()) {
                    if (!foundPos) {
                        extraY -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.m_83281_()) break;
                AABB aabb = shape.m_83215_();
                if (!aabb.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82390_(vec)) {
                    if (aabb.f_82292_ < 1.0) break;
                    extraY += 1.0;
                    continue;
                }
                extraY += (double)step;
            }
            level.m_7106_(particle, extraX, center.f_82480_ + 0.1, extraZ, 0.0, 0.0, 0.0);
        }
    }

    public static void addParticle(Player player, int radius, double xx, double yy, double zz, Color[] colors) {
        Level world = player.m_9236_();
        RandomSource random = world.f_46441_;
        for (int i = 0; i < radius; ++i) {
            Vec3 direction = new Vec3(1.0, 0.0, 0.0).m_82524_((float)Math.toRadians(random.m_188501_() * 360.0f)).m_82541_().m_82490_((double)MathUtils.randomFloat((RandomSource)random));
            double x = MathUtils.randomFloat((RandomSource)random) * (float)radius;
            double z = (double)MathUtils.randomFloat((RandomSource)random) * Math.sqrt((double)(radius * radius) - x * x);
            player.m_9236_().m_6493_(it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)colors[random.m_188503_(colors.length)], (float)((float)(1.0 + (double)radius / 2.0)), (int)80, (float)0.96f), true, xx + x, yy + (double)MathUtils.randomFloat((RandomSource)random) * (double)radius / 10.0, zz + z, direction.f_82479_ * 0.46, direction.f_82480_ * 0.1, direction.f_82481_ * 0.46);
        }
    }
}

