/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.structures;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RunesLootModifier
extends LootModifier {
    public static final Codec<RunesLootModifier> CODEC = RecordCodecBuilder.create(inst -> RunesLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RunesLootModifier::new));
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> CODECS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"arcane_abilities");
    public static final RegistryObject<Codec<RunesLootModifier>> XP_RUNE = CODECS.register("skill_xp_rune", () -> CODEC);

    public RunesLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        RandomSource random = context.m_230907_();
        if (random.m_188500_() <= 0.25) {
            ItemStack XpRune2 = new ItemStack((ItemLike)ItemRegistry.XP_RUNE.get(), 1);
            CompoundTag tag = XpRune2.m_41784_();
            tag.m_128405_("type", random.m_216339_(1, 5));
            if (this.isRareChest(lootId) || this.isLegendaryChest(lootId)) {
                generatedLoot.add((Object)XpRune2);
            }
        }
        return generatedLoot;
    }

    private boolean isRareChest(String lootId) {
        return lootId.matches("[\\w]+:chests\\/[\\w_\\/]*rare[\\w_\\/]*");
    }

    private boolean isLegendaryChest(String lootId) {
        return lootId.matches("[\\w]+:chests\\/[\\w_\\/]*legendary[\\w_\\/]*");
    }

    public static void register() {
        CODECS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public Codec codec() {
        return (Codec)XP_RUNE.get();
    }
}

