/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.skills;

import it.mralxart.arcaneabilities.data.SkillsBuilder;
import java.util.ArrayList;
import java.util.List;

public class Skill {
    private String id;
    private int level;
    private boolean purchased;
    private boolean active;
    private String category;
    private final List<String> connectedSkills = new ArrayList<String>();

    public String toString() {
        return "Skill{id='" + this.id + ", category=" + this.category + ", level=" + this.level + ", purchased=" + this.purchased + ", active=" + this.active + ", connect=" + String.valueOf(this.connectedSkills) + "}";
    }

    public void connect(Skill otherSkill) {
        this.connectedSkills.add(otherSkill.getId());
    }

    public void connect(SkillsBuilder otherSkill) {
        this.connectedSkills.add(otherSkill.getId());
    }

    public Skill(String id, int level, boolean purchased, boolean active, String category) {
        this.id = id;
        this.level = level;
        this.purchased = purchased;
        this.active = active;
        this.category = category;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setPurchased(boolean purchased) {
        this.purchased = purchased;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Skill)) {
            return false;
        }
        Skill other = (Skill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.isPurchased() != other.isPurchased()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List<String> this$connectedSkills = this.getConnectedSkills();
        List<String> other$connectedSkills = other.getConnectedSkills();
        return !(this$connectedSkills == null ? other$connectedSkills != null : !((Object)this$connectedSkills).equals(other$connectedSkills));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Skill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + (this.isPurchased() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List<String> $connectedSkills = this.getConnectedSkills();
        result = result * 59 + ($connectedSkills == null ? 43 : ((Object)$connectedSkills).hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isPurchased() {
        return this.purchased;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getConnectedSkills() {
        return this.connectedSkills;
    }

    public Skill() {
    }
}

