/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.network.messages;

import it.mralxart.arcaneabilities.capability.skills.PlayerSkillsUtils;
import it.mralxart.arcaneabilities.data.SkillManager;
import it.mralxart.arcaneabilities.network.Network;
import it.mralxart.arcaneabilities.utils.ToggleUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillsButtonMessage {
    private final String skillid;

    public SkillsButtonMessage(FriendlyByteBuf buffer) {
        this.skillid = buffer.m_130277_();
    }

    public SkillsButtonMessage(String skillid) {
        this.skillid = skillid;
    }

    public static void buffer(SkillsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.skillid);
    }

    public static void handler(SkillsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            SkillsButtonMessage.handleButtonAction((Player)entity, message.skillid);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player player, String skill) {
        Level world = player.m_9236_();
        boolean isPurchased = PlayerSkillsUtils.isSkillPurchasedById(player, skill);
        boolean isConnectedSkillPurchased = PlayerSkillsUtils.isConnectedSkillUnlocked(player, skill);
        boolean isEnabled = PlayerSkillsUtils.isSkillActiveById(player, skill);
        boolean canPurchase = PlayerSkillsUtils.mayPlayerPurchase(player, skill);
        boolean mayPlayerUpgrade = PlayerSkillsUtils.mayPlayerUpgrade(player, skill);
        if ("buy".equals(PlayerSkillsUtils.getSwipe(player))) {
            if (canPurchase && !isPurchased && isConnectedSkillPurchased) {
                PlayerSkillsUtils.setSkillPurchasedById(player, skill, true);
                PlayerSkillsUtils.setSkillPoints(player, PlayerSkillsUtils.getSkillPoints(player) - SkillManager.getCostById(skill));
                PlayerSkillsUtils.addSkillLevelById(player, skill, 1);
                PlayerSkillsUtils.setSkillActiveById(player, skill, true);
            }
        } else if ("swipe".equals(PlayerSkillsUtils.getSwipe(player))) {
            if (isPurchased) {
                PlayerSkillsUtils.setSkillActiveById(player, skill, !isEnabled);
                ToggleUtils.toggle(player);
            }
        } else if ("upgrade".equals(PlayerSkillsUtils.getSwipe(player)) && isPurchased && mayPlayerUpgrade && isConnectedSkillPurchased) {
            PlayerSkillsUtils.addSkillLevelById(player, skill, 1);
            PlayerSkillsUtils.setSkillPoints(player, PlayerSkillsUtils.getSkillPoints(player) - SkillManager.getUpCostById(skill));
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Network.addNetworkMessage(SkillsButtonMessage.class, SkillsButtonMessage::buffer, SkillsButtonMessage::new, SkillsButtonMessage::handler);
    }
}

