/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.network.messages;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ParticleSpawnerPacket {
    private final ParticleOptions particleData;
    private final double x;
    private final double y;
    private final double z;
    private final double xd;
    private final double yd;
    private final double zd;

    public ParticleSpawnerPacket(FriendlyByteBuf buffer) {
        ParticleType particleType = (ParticleType)buffer.m_236816_((IdMap)BuiltInRegistries.f_257034_);
        this.particleData = this.deserializeParticle(Objects.requireNonNull(particleType), buffer);
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.xd = buffer.readDouble();
        this.yd = buffer.readDouble();
        this.zd = buffer.readDouble();
    }

    private <T extends ParticleOptions> T deserializeParticle(ParticleType<T> particleType, FriendlyByteBuf buffer) {
        return (T)particleType.m_123743_().m_6507_(particleType, buffer);
    }

    public ParticleSpawnerPacket(ParticleOptions particleData, double xCoord, double yCoord, double zCoord, double xVelocity, double yVelocity, double zVelocity) {
        this.particleData = particleData;
        this.x = xCoord;
        this.y = yCoord;
        this.z = zCoord;
        this.xd = xVelocity;
        this.yd = yVelocity;
        this.zd = zVelocity;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)this.particleData.m_6012_());
        this.particleData.m_7711_(buffer);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.xd);
        buffer.writeDouble(this.yd);
        buffer.writeDouble(this.zd);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world != null && !minecraft.m_91104_()) {
            world.m_6493_(this.particleData, true, this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }
    }
}

