/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.network.messages;

import it.mralxart.arcaneabilities.network.Network;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyPressMessage {
    int type;
    int pressedms;

    public KeyPressMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public KeyPressMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(KeyPressMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(KeyPressMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> KeyPressMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player player, int type, int pressedms) {
        Level world = player.m_9236_();
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Network.addNetworkMessage(KeyPressMessage.class, KeyPressMessage::buffer, KeyPressMessage::new, KeyPressMessage::handler);
    }
}

