/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.network.messages;

import it.mralxart.arcaneabilities.capability.skills.PlayerSkills;
import it.mralxart.arcaneabilities.network.Network;
import it.mralxart.arcaneabilities.utils.CapabilityUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CapabilitySyncPacket {
    private final CompoundTag data;

    public CapabilitySyncPacket(FriendlyByteBuf buf) {
        this.data = buf.m_130260_();
    }

    public CapabilitySyncPacket(CompoundTag data) {
        this.data = data;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return;
            }
            Optional capability = CapabilityUtils.getRelicsCapability((Player)player).resolve();
            if (capability.isEmpty()) {
                return;
            }
            ((PlayerSkills)capability.get()).deserializeNBT((Tag)this.data);
        } else {
            ctx.get().enqueueWork(this::handleClient);
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Optional capability = CapabilityUtils.getRelicsCapability((Player)player).resolve();
            capability.ifPresent(playerSkills -> playerSkills.deserializeNBT((Tag)this.data));
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Network.addNetworkMessage(CapabilitySyncPacket.class, CapabilitySyncPacket::toBytes, CapabilitySyncPacket::new, CapabilitySyncPacket::handle);
    }
}

