/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.network;

import it.mralxart.arcaneabilities.network.messages.CapabilitySyncPacket;
import it.mralxart.arcaneabilities.network.messages.ParticleSpawnerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static SimpleChannel INSTANCE;
    private static int ID;

    private static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("arcane_abilities", "network"), () -> "1.0", s -> true, s -> true);
        INSTANCE.messageBuilder(CapabilitySyncPacket.class, NetworkHandler.nextID()).encoder(CapabilitySyncPacket::toBytes).decoder(CapabilitySyncPacket::new).consumerMainThread(CapabilitySyncPacket::handle).add();
        INSTANCE.messageBuilder(ParticleSpawnerPacket.class, NetworkHandler.nextID()).encoder(ParticleSpawnerPacket::toBytes).decoder(ParticleSpawnerPacket::new).consumerMainThread(ParticleSpawnerPacket::handle).add();
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        INSTANCE.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToClient(Object packet, Player player) {
        INSTANCE.sendTo(packet, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAll(Object packet) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            INSTANCE.send(PacketDistributor.ALL.noArg(), packet);
        }
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }

    public static void sendToClients(PacketDistributor.PacketTarget target, Object packet) {
        INSTANCE.send(target, packet);
    }

    static {
        ID = 0;
    }
}

