/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityCache;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import it.hurts.sskirillss.relics.system.casts.handlers.HUDRenderHandler;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import it.mralxart.arcaneabilities.mixins.HUDRenderHandlerAccessor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HUDRenderHandler.class}, remap=false)
public class HUDRenderHandlerMixin {
    @Unique
    private static final ThreadLocal<ItemStack> arcaneAbilities$contextStack = new ThreadLocal();

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="HEAD")})
    private static void head(GuiGraphics guiGraphics, float partialTicks, CallbackInfo ci) {
        AbilityReference selectedAbility = HUDRenderHandlerAccessor.getAbilityByIndex(HUDRenderHandlerAccessor.getSelectedIndex());
        if (selectedAbility != null) {
            arcaneAbilities$contextStack.set(selectedAbility.getSlot().gatherStack((Player)Minecraft.m_91087_().f_91074_));
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="TAIL")})
    private static void tail(GuiGraphics guiGraphics, float partialTicks, CallbackInfo ci) {
        arcaneAbilities$contextStack.remove();
    }

    @Redirect(method={"drawAbility"}, at=@At(value="NEW", target="net/minecraft/resources/ResourceLocation", ordinal=0, remap=true))
    private static ResourceLocation redirectCardIcon(String namespace, String path, GuiGraphics guiGraphics, LocalPlayer player, int realIndex) {
        CombinedRelicItem relicItem;
        ResourceLocation originId;
        Item item;
        int relativeIndex = HUDRenderHandlerAccessor.getRelativeIndex(realIndex);
        AbilityReference abilityReference = HUDRenderHandlerAccessor.getAbilityByIndex(relativeIndex);
        if (abilityReference == null) {
            return new ResourceLocation(namespace, path);
        }
        ItemStack stack = abilityReference.getSlot().gatherStack((Player)player);
        String abilityId = abilityReference.getId();
        if (!abilityId.startsWith("synergy_") && (item = stack.m_41720_()) instanceof CombinedRelicItem && (originId = (relicItem = (CombinedRelicItem)item).getAbilityOrigin(stack, abilityId)) != null) {
            String newPath = path.substring(path.lastIndexOf(47) + 1);
            return new ResourceLocation(namespace, "textures/gui/description/cards/" + originId.m_135815_() + "/" + newPath);
        }
        return new ResourceLocation(namespace, path);
    }

    @Redirect(method={"drawAbility"}, at=@At(value="INVOKE", target="Lit/hurts/sskirillss/relics/utils/RenderUtils;renderTextureFromCenter(Lcom/mojang/blaze3d/vertex/PoseStack;FFFFF)V", ordinal=0))
    private static void drawAbilityCard(PoseStack poseStack, float x, float y, float width, float height, float scale, GuiGraphics guiGraphics, LocalPlayer player, int realIndex, float originalX, float originalY, float partialTicks) {
        Item item;
        int relativeIndex = HUDRenderHandlerAccessor.getRelativeIndex(realIndex);
        AbilityReference abilityReference = HUDRenderHandlerAccessor.getAbilityByIndex(relativeIndex);
        if (abilityReference == null) {
            RenderUtils.renderTextureFromCenter((PoseStack)poseStack, (float)x, (float)y, (float)width, (float)height, (float)scale);
            return;
        }
        ItemStack stack = abilityReference.getSlot().gatherStack((Player)player);
        String abilityId = abilityReference.getId();
        if (abilityId.startsWith("synergy_") && (item = stack.m_41720_()) instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            poseStack.m_85836_();
            float calculatedScale = (float)(1.0 + Mth.m_14008_((double)Math.pow(15.0, -Math.abs(realIndex)), (double)0.0, (double)0.2f) + (realIndex == 0 ? Math.sin(((float)player.f_19797_ + partialTicks) * 0.1f) * (double)0.05f : 0.0));
            poseStack.m_252880_(originalX - calculatedScale + 1.0f, originalY - calculatedScale + 2.0f, 0.0f);
            poseStack.m_85841_(scale, scale, 1.0f);
            HUDRenderHandlerMixin.renderCard(poseStack, relicItem, (Player)player, stack, abilityId);
            poseStack.m_85849_();
        } else {
            RenderUtils.renderTextureFromCenter((PoseStack)poseStack, (float)x, (float)y, (float)width, (float)height, (float)scale);
        }
    }

    @Redirect(method={"drawAbility"}, at=@At(value="INVOKE", target="Lit/hurts/sskirillss/relics/utils/RenderUtils;renderTextureFromCenter(Lcom/mojang/blaze3d/vertex/PoseStack;FFFFFFFFF)V", ordinal=0))
    private static void drawAbilityStatus(PoseStack poseStack, float x, float y, float u, float v, float texWidth, float texHeight, float renderWidth, float renderHeight, float scale) {
        int realIndex = HUDRenderHandlerAccessor.getSelectedIndex();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int relativeIndex = HUDRenderHandlerAccessor.getRelativeIndex(realIndex);
        AbilityReference abilityReference = HUDRenderHandlerAccessor.getAbilityByIndex(relativeIndex);
        if (abilityReference == null) {
            RenderUtils.renderTextureFromCenter((PoseStack)poseStack, (float)x, (float)y, (float)u, (float)v, (float)texWidth, (float)texHeight, (float)renderWidth, (float)renderHeight, (float)scale);
            return;
        }
        ItemStack stack = abilityReference.getSlot().gatherStack((Player)player);
        String abilityId = abilityReference.getId();
        if (!abilityId.startsWith("synergy_") || !(stack.m_41720_() instanceof CombinedRelicItem)) {
            RenderUtils.renderTextureFromCenter((PoseStack)poseStack, (float)x, (float)y, (float)u, (float)v, (float)texWidth, (float)texHeight, (float)renderWidth, (float)renderHeight, (float)scale);
        }
    }

    @Inject(method={"drawAbilityStatusIcon"}, at={@At(value="HEAD")})
    private static void head(AbilityCache cache, GuiGraphics guiGraphics, float x, float y, float texWidth, float texHeight, float scale, @Nullable AnimationData animation, long ticks, float partialTicks, CallbackInfo ci) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, 0.0, 2500.0);
    }

    @Inject(method={"drawAbilityStatusIcon"}, at={@At(value="TAIL")})
    private static void tail(AbilityCache cache, GuiGraphics guiGraphics, float x, float y, float texWidth, float texHeight, float scale, @Nullable AnimationData animation, long ticks, float partialTicks, CallbackInfo ci) {
        guiGraphics.m_280168_().m_85849_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/Component;translatable(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", remap=true))
    private static MutableComponent modifyTranslate(String key) {
        int selectedIndex = HUDRenderHandlerAccessor.getSelectedIndex();
        AbilityReference abilityReference = HUDRenderHandlerAccessor.getAbilityByIndex(selectedIndex);
        if (abilityReference == null) {
            return Component.m_237115_((String)key);
        }
        ItemStack stack = arcaneAbilities$contextStack.get();
        Item item = stack.m_41720_();
        if (!(item instanceof CombinedRelicItem)) {
            return Component.m_237115_((String)key);
        }
        CombinedRelicItem combinedRelic = (CombinedRelicItem)item;
        String abilityId = abilityReference.getId();
        if (abilityId.startsWith("synergy_")) {
            if (!key.contains(".predicate.")) return HUDRenderHandlerMixin.getComponent(combinedRelic, stack, abilityId);
            String newKey = key.substring(key.lastIndexOf(46) + 1);
            int var1 = newKey.lastIndexOf(95);
            if (var1 == -1) return Component.m_237115_((String)key);
            String var2 = newKey.substring(0, var1);
            String var3 = newKey.substring(var1 + 1);
            ResourceLocation originId = combinedRelic.getAbilityOrigin(stack, var2);
            if (originId == null) return Component.m_237115_((String)key);
            return Component.m_237115_((String)("tooltip.relics." + originId.m_135815_() + ".ability." + var2 + ".predicate." + var3));
        }
        ResourceLocation originId = combinedRelic.getAbilityOrigin(stack, abilityId);
        if (originId == null) return Component.m_237115_((String)key);
        return Component.m_237115_((String)key.replace(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_(), originId.m_135815_()));
    }

    @Redirect(method={"render"}, at=@At(value="NEW", target="net/minecraft/resources/ResourceLocation", remap=true))
    private static ResourceLocation getTexture(String namespace, String path) {
        int selectedIndex;
        AbilityReference abilityReference;
        if (path.contains("textures/gui/description/icons/") && (abilityReference = HUDRenderHandlerAccessor.getAbilityByIndex(selectedIndex = HUDRenderHandlerAccessor.getSelectedIndex())) != null) {
            Item item;
            ItemStack stack = arcaneAbilities$contextStack.get();
            String abilityId = abilityReference.getId();
            if (abilityId.startsWith("synergy_") && (item = stack.m_41720_()) instanceof CombinedRelicItem) {
                CombinedRelicItem relic = (CombinedRelicItem)item;
                String newPath = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                int var1 = newPath.lastIndexOf(95);
                if (var1 != -1) {
                    String var2 = newPath.substring(0, var1);
                    String var3 = newPath.substring(var1 + 1);
                    ResourceLocation originId = relic.getAbilityOrigin(stack, var2);
                    if (originId != null) {
                        return new ResourceLocation(namespace, "textures/gui/description/icons/" + originId.m_135815_() + "/" + var3 + ".png");
                    }
                }
            }
        }
        return new ResourceLocation(namespace, path);
    }

    @Unique
    private static void renderCard(PoseStack poseStack, CombinedRelicItem relicItem, Player player, ItemStack stack, String abilityId) {
        List<String> parentIds = relicItem.getSynergyParents(stack, abilityId);
        if (parentIds == null || parentIds.size() < 2) {
            return;
        }
        AbilityData parent1Data = AbilityRelicsData.get(parentIds.get(0)).orElse(null);
        AbilityData parent2Data = AbilityRelicsData.get(parentIds.get(1)).orElse(null);
        if (parent1Data == null || parent2Data == null) {
            return;
        }
        ResourceLocation tex1 = HUDRenderHandlerMixin.getCardTexture(relicItem, player, stack, parent1Data);
        ResourceLocation tex2 = HUDRenderHandlerMixin.getCardTexture(relicItem, player, stack, parent2Data);
        poseStack.m_85836_();
        poseStack.m_85837_(-10.0, -14.5, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float width = 20.0f;
        float height = 29.0f;
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), width, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), width, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        Tesselator.m_85913_().m_85914_();
        HUDRenderHandlerMixin.drawGradientTexture(poseStack, tex1, 0.0f, 0.0f, 20.0f, 29.0f, true);
        HUDRenderHandlerMixin.drawGradientTexture(poseStack, tex2, 0.0f, 0.0f, 20.0f, 29.0f, false);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @Unique
    private static void drawGradientTexture(PoseStack poseStack, ResourceLocation texture, float x, float y, float width, float height, boolean isLeftPart) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alphaLeft = isLeftPart ? 1.0f : 0.0f;
        float alphaRight = isLeftPart ? 0.0f : 1.0f;
        float x2 = x + width;
        float y2 = y + height;
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, 0.0f).m_7421_(u1, v1).m_85950_(r, g, b, alphaLeft).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y2, 0.0f).m_7421_(u1, v2).m_85950_(r, g, b, alphaLeft).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y2, 0.0f).m_7421_(u2, v2).m_85950_(r, g, b, alphaRight).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y, 0.0f).m_7421_(u2, v1).m_85950_(r, g, b, alphaRight).m_5752_();
        tesselator.m_85914_();
    }

    @Unique
    private static ResourceLocation getCardTexture(CombinedRelicItem relicItem, Player player, ItemStack stack, AbilityData abilityData) {
        ResourceLocation origin = relicItem.getAbilityOrigin(stack, abilityData.getId());
        if (origin == null) {
            return new ResourceLocation("null");
        }
        String iconName = (String)abilityData.getIcon().apply((Object)player, (Object)stack, (Object)abilityData.getId());
        return new ResourceLocation("relics", "textures/gui/description/cards/" + origin.m_135815_() + "/" + iconName + ".png");
    }

    @Unique
    private static MutableComponent getComponent(CombinedRelicItem relicItem, ItemStack stack, String abilityId) {
        List<String> parentIds = relicItem.getSynergyParents(stack, abilityId);
        if (parentIds != null && parentIds.size() >= 2) {
            MutableComponent component1 = HUDRenderHandlerMixin.getTranslateComponent(relicItem, stack, parentIds.get(0));
            MutableComponent component2 = HUDRenderHandlerMixin.getTranslateComponent(relicItem, stack, parentIds.get(1));
            return component1.m_7220_((Component)Component.m_237113_((String)" & ")).m_7220_((Component)component2);
        }
        return Component.m_237113_((String)abilityId);
    }

    @Unique
    private static MutableComponent getTranslateComponent(CombinedRelicItem relicItem, ItemStack stack, String abilityId) {
        ResourceLocation origin = relicItem.getAbilityOrigin(stack, abilityId);
        if (origin != null) {
            return Component.m_237115_((String)("tooltip.relics." + origin.m_135815_() + ".ability." + abilityId));
        }
        return Component.m_237113_((String)abilityId);
    }
}

