/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.mixins;

import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import it.mralxart.arcaneabilities.utils.RelicsUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={EntityUtils.class}, remap=false)
public class EntityUtilsMixin {
    @Inject(method={"findEquippedCurio(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/Item;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void onFindEquippedCurio(Entity entity, Item item, CallbackInfoReturnable<ItemStack> cir) {
        if (!((ItemStack)cir.getReturnValue()).m_41619_()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemId == null) {
                return;
            }
            CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStackInSlot(i);
                    Item patt1739$temp = stack.m_41720_();
                    if (!(patt1739$temp instanceof CombinedRelicItem)) continue;
                    CombinedRelicItem relicItem = (CombinedRelicItem)patt1739$temp;
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) continue;
                    ResourceLocation parent1Id = new ResourceLocation(tag.m_128461_("Parent1"));
                    ResourceLocation parent2Id = new ResourceLocation(tag.m_128461_("Parent2"));
                    if (!itemId.equals((Object)parent1Id) && !itemId.equals((Object)parent2Id)) continue;
                    ItemStack child = relicItem.createChildStack(stack, new ResourceLocation(itemId.toString()));
                    RelicsUtils.putSaveStack(stack, child);
                    cir.setReturnValue((Object)child);
                    return;
                }
            });
        }
    }
}

