/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import it.mralxart.arcaneabilities.utils.RelicsUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbilityDescriptionScreen.class}, remap=false)
public class AbilityDescriptionScreenMixin {
    @Shadow
    public ItemStack stack;
    @Shadow
    public String ability;

    @Redirect(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/Component;translatable(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", remap=true), remap=true)
    private MutableComponent modifyTranslate(String key) {
        Item item = this.stack.m_41720_();
        if (item instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            if (this.ability.startsWith("synergy_")) {
                if (key.contains(".stat.") && key.endsWith(".title")) {
                    ResourceLocation statOriginId;
                    String ownerAbilityId;
                    String statId = this.arcaneAbilities$getIdByKey(key);
                    if (statId != null && (ownerAbilityId = this.arcaneAbilities$findOwner(relicItem, statId)) != null && (statOriginId = relicItem.getAbilityOrigin(this.stack, ownerAbilityId)) != null) {
                        return Component.m_237115_((String)("tooltip.relics." + statOriginId.m_135815_() + ".ability." + ownerAbilityId + ".stat." + statId + ".title"));
                    }
                } else {
                    CompoundTag tag = relicItem.getSynergyTag(this.stack, this.ability);
                    if (tag != null) {
                        String parentId;
                        ResourceLocation originId;
                        if (key.endsWith(this.ability)) {
                            List<String> parentIds = relicItem.getSynergyParents(this.stack, this.ability);
                            if (parentIds != null && parentIds.size() >= 2) {
                                MutableComponent component1 = this.arcaneAbilities$getComponent(relicItem, parentIds.get(0));
                                MutableComponent component2 = this.arcaneAbilities$getComponent(relicItem, parentIds.get(1));
                                return component1.m_7220_((Component)Component.m_237113_((String)" & ")).m_7220_((Component)component2);
                            }
                        } else if (key.endsWith(".description") && (originId = relicItem.getAbilityOrigin(this.stack, parentId = tag.m_128461_("parent1"))) != null) {
                            return Component.m_237115_((String)("tooltip.relics." + originId.m_135815_() + ".ability." + parentId + ".description"));
                        }
                    }
                }
            } else {
                ResourceLocation originId = relicItem.getAbilityOrigin(this.stack, this.ability);
                if (originId != null) {
                    String newKey = key.replace(ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_(), originId.m_135815_());
                    return Component.m_237115_((String)newKey);
                }
            }
        }
        return Component.m_237115_((String)key);
    }

    @Redirect(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/Component;translatable(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/network/chat/MutableComponent;", remap=true), remap=true)
    private MutableComponent modifyTranslate2(String key, Object[] args) {
        Item item = this.stack.m_41720_();
        if (item instanceof CombinedRelicItem) {
            ResourceLocation originId;
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            if (key.contains(".stat.") && key.endsWith(".value") && this.ability.startsWith("synergy_")) {
                ResourceLocation originId2;
                String owner;
                String statId = this.arcaneAbilities$getIdByKey(key);
                if (statId != null && (owner = this.arcaneAbilities$findOwner(relicItem, statId)) != null && (originId2 = relicItem.getAbilityOrigin(this.stack, owner)) != null) {
                    return Component.m_237110_((String)("tooltip.relics." + originId2.m_135815_() + ".ability." + owner + ".stat." + statId + ".value"), (Object[])args);
                }
            } else if (!this.ability.startsWith("synergy_") && (originId = relicItem.getAbilityOrigin(this.stack, this.ability)) != null) {
                String correctKey = key.replace(ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_(), originId.m_135815_());
                return Component.m_237110_((String)correctKey, (Object[])args);
            }
        }
        return Component.m_237110_((String)key, (Object[])args);
    }

    @Inject(method={"renderBackground"}, at={@At(value="TAIL")}, remap=false)
    private void renderSynergyIcon(GuiGraphics guiGraphics, CallbackInfo ci) {
        Item item;
        if (!this.ability.startsWith("synergy_") || !((item = this.stack.m_41720_()) instanceof CombinedRelicItem)) {
            return;
        }
        CombinedRelicItem relicItem = (CombinedRelicItem)item;
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)this;
        List<String> parentIds = relicItem.getSynergyParents(this.stack, this.ability);
        if (parentIds == null || parentIds.size() < 2) {
            return;
        }
        AbilityData abilityData1 = AbilityRelicsData.get(parentIds.get(0)).orElse(null);
        AbilityData abilityData2 = AbilityRelicsData.get(parentIds.get(1)).orElse(null);
        if (abilityData1 == null || abilityData2 == null) {
            return;
        }
        int x = (screen.f_96543_ - screen.backgroundWidth) / 2;
        int y = (screen.f_96544_ - screen.backgroundHeight) / 2;
        ResourceLocation texture1 = this.arcaneAbilities$getCardTexture(relicItem, abilityData1);
        ResourceLocation texture2 = this.arcaneAbilities$getCardTexture(relicItem, abilityData2);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 67), (float)(y + 57), 10.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float width = 34.0f;
        float height = 49.0f;
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), width, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), width, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        Tesselator.m_85913_().m_85914_();
        this.arcaneAbilities$drawGradientTexture(poseStack, texture1, 0.0f, 0.0f, 34.0f, 49.0f, true);
        this.arcaneAbilities$drawGradientTexture(poseStack, texture2, 0.0f, 0.0f, 34.0f, 49.0f, false);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @Unique
    private ResourceLocation arcaneAbilities$getCardTexture(CombinedRelicItem relicItem, AbilityData abilityData) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return new ResourceLocation("null");
        }
        ResourceLocation parentOrigin = relicItem.getAbilityOrigin(this.stack, abilityData.getId());
        if (parentOrigin == null) {
            return new ResourceLocation("null");
        }
        String iconName = (String)abilityData.getIcon().apply((Object)player, (Object)this.stack, (Object)abilityData.getId());
        return new ResourceLocation("relics", "textures/gui/description/cards/" + parentOrigin.m_135815_() + "/" + iconName + ".png");
    }

    @Redirect(method={"renderBackground"}, at=@At(value="NEW", target="net/minecraft/resources/ResourceLocation", remap=true), remap=true)
    private ResourceLocation getTexture(String namespace, String path) {
        Item item = this.stack.m_41720_();
        if (item instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            ResourceLocation originId = relicItem.getAbilityOrigin(this.stack, this.ability);
            if (!(this.ability.startsWith("synergy_") && originId != null || originId == null)) {
                String newPath = path.substring(path.lastIndexOf(47) + 1);
                String result = "textures/gui/description/cards/" + originId.m_135815_() + "/" + newPath;
                return new ResourceLocation(namespace, result);
            }
        }
        return new ResourceLocation(namespace, path);
    }

    @Unique
    private void arcaneAbilities$drawGradientTexture(PoseStack poseStack, ResourceLocation texture, float x, float y, float width, float height, boolean leftRight) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        float alpha1 = leftRight ? 1.0f : 0.0f;
        float alpha2 = leftRight ? 0.0f : 1.0f;
        float x2 = x + width;
        float y2 = y + height;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha1).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y2, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha1).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y2, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha2).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha2).m_5752_();
        tesselator.m_85914_();
    }

    @Unique
    private MutableComponent arcaneAbilities$getComponent(CombinedRelicItem relicItem, String abilityId) {
        ResourceLocation origin = relicItem.getAbilityOrigin(this.stack, abilityId);
        return Component.m_237115_((String)("tooltip.relics." + origin.m_135815_() + ".ability." + abilityId));
    }

    @Unique
    private String arcaneAbilities$getIdByKey(String key) {
        try {
            int stat = key.indexOf(".stat.") + 6;
            int lastIndex = key.lastIndexOf(46);
            if (stat < lastIndex) {
                return key.substring(stat, lastIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Redirect(method={"renderBackground"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", remap=false), remap=true)
    private Iterator<String> getStats(Set<String> stats) {
        if (this.ability.startsWith("synergy_") && stats.size() > 4) {
            ArrayList<String> allStats = new ArrayList<String>(stats);
            long time = System.currentTimeMillis();
            int num = (int)Math.ceil((double)allStats.size() / 4.0);
            int var2 = (int)(time / 2000L % (long)num);
            int var3 = var2 * 4;
            int result = Math.min(var3 + 4, allStats.size());
            return allStats.subList(var3, result).iterator();
        }
        return stats.iterator();
    }

    @Unique
    @Nullable
    private String arcaneAbilities$findOwner(CombinedRelicItem relicItem, String statId) {
        CompoundTag tag = relicItem.getSynergyTag(this.stack, this.ability);
        if (tag == null) {
            return null;
        }
        ListTag parentIds = tag.m_128437_("ParentAbilities", 8);
        for (Tag parentIdTag : parentIds) {
            String id = parentIdTag.m_7916_();
            AbilityData abilityData = AbilityRelicsData.get(id).orElse(null);
            if (abilityData == null || !abilityData.getStats().containsKey(statId)) continue;
            return id;
        }
        return null;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=true)
    private void setupRenderContext(GuiGraphics guiGraphics, int x, int y, float partialTicks, CallbackInfo ci) {
        if (this.stack.m_41720_() instanceof CombinedRelicItem) {
            RelicsUtils.setCurrentStack(this.stack);
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, remap=true)
    private void setupInitContext(CallbackInfo ci) {
        if (this.stack != null && this.stack.m_41720_() instanceof CombinedRelicItem) {
            RelicsUtils.setCurrentStack(this.stack);
        }
    }
}

