/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.mixins;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.AbilityCardWidget;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.mralxart.arcaneabilities.data.AbilityRelicsData;
import it.mralxart.arcaneabilities.items.relics.CombinedRelicItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbilityCardWidget.class}, remap=false)
public abstract class AbilityCardWidgetMixin {
    @Shadow
    private String ability;
    @Shadow
    private RelicDescriptionScreen screen;

    @Redirect(method={"renderWidget"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V", ordinal=0, remap=true), remap=true)
    private void renderCard(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, float u, float v, int width, int height, int texWidth, int texHeight) {
        Item item;
        if (this.ability.startsWith("synergy_") && (item = this.screen.stack.m_41720_()) instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            List<String> parentIds = relicItem.getSynergyParents(this.screen.stack, this.ability);
            if (parentIds != null && parentIds.size() >= 2) {
                AbilityData parent1Data = AbilityRelicsData.get(parentIds.get(0)).orElse(null);
                AbilityData parent2Data = AbilityRelicsData.get(parentIds.get(1)).orElse(null);
                if (parent1Data != null && parent2Data != null) {
                    PoseStack poseStack = guiGraphics.m_280168_();
                    boolean canUse = relicItem.canUseAbility(this.screen.stack, this.ability);
                    ResourceLocation card1Texture = this.arcaneAbilities$getCardTexture(relicItem, parent1Data);
                    ResourceLocation card2Texture = this.arcaneAbilities$getCardTexture(relicItem, parent2Data);
                    float color = canUse ? 1.05f + (float)Math.sin((float)(player.f_19797_ + this.ability.length() * 10) * 0.2f) * 0.1f : 0.25f;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                    guiGraphics.m_280411_(card1Texture, x, y, 22, 31, 0.0f, 0.0f, 11, 31, 22, 31);
                    guiGraphics.m_280411_(card2Texture, x, y, 22, 31, 11.0f, 0.0f, 11, 31, 22, 31);
                    this.arcaneAbilities$drawGradientTexture(poseStack, card1Texture, x, y, 22.0f, 31.0f, true);
                    this.arcaneAbilities$drawGradientTexture(poseStack, card2Texture, x, y, 22.0f, 31.0f, false);
                    return;
                }
            }
        }
        guiGraphics.m_280163_(texture, x, y, u, v, width, height, texWidth, texHeight);
    }

    @Redirect(method={"renderWidget"}, at=@At(value="INVOKE", target="Lit/hurts/sskirillss/relics/items/relics/base/data/leveling/AbilityData;getRequiredLevel()I", remap=false), remap=true)
    private int getRequiredLevel(AbilityData abilityData) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof CombinedRelicItem)) {
            return abilityData.getRequiredLevel();
        }
        CombinedRelicItem relicItem = (CombinedRelicItem)item;
        if (this.ability.startsWith("synergy_")) {
            List<String> parentIds = relicItem.getSynergyParents(this.screen.stack, this.ability);
            if (parentIds != null && !parentIds.isEmpty()) {
                return parentIds.stream().map(AbilityRelicsData::get).filter(Optional::isPresent).map(Optional::get).mapToInt(AbilityData::getRequiredLevel).max().orElse(0);
            }
        } else {
            Optional<AbilityData> optional = AbilityRelicsData.get(this.ability);
            if (optional.isPresent()) {
                return optional.get().getRequiredLevel();
            }
        }
        return abilityData.getRequiredLevel();
    }

    @Unique
    private ResourceLocation arcaneAbilities$getCardTexture(CombinedRelicItem relicItem, AbilityData abilityData) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return new ResourceLocation("null");
        }
        ResourceLocation origin = relicItem.getAbilityOrigin(this.screen.stack, abilityData.getId());
        if (origin == null) {
            return new ResourceLocation("null");
        }
        String icon = (String)abilityData.getIcon().apply((Object)player, (Object)this.screen.stack, (Object)abilityData.getId());
        return new ResourceLocation("relics", "textures/gui/description/cards/" + origin.m_135815_() + "/" + icon + ".png");
    }

    @Redirect(method={"renderWidget"}, at=@At(value="NEW", target="net/minecraft/resources/ResourceLocation", remap=true), remap=true)
    private ResourceLocation getTextureLocation(String namespace, String path) {
        Item item = this.screen.stack.m_41720_();
        if (item instanceof CombinedRelicItem) {
            CombinedRelicItem relicItem = (CombinedRelicItem)item;
            ResourceLocation origin = relicItem.getAbilityOrigin(this.screen.stack, this.ability);
            if (!(this.ability.startsWith("synergy_") && origin != null || origin == null)) {
                String icon = path.substring(path.lastIndexOf(47) + 1);
                String result = "textures/gui/description/cards/" + origin.m_135815_() + "/" + icon;
                return new ResourceLocation(namespace, result);
            }
        }
        return new ResourceLocation(namespace, path);
    }

    @ModifyVariable(method={"onHovered(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at=@At(value="STORE"), name={"entries"}, remap=false)
    private List<MutableComponent> modifyEntries(List<MutableComponent> originalEntries) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof CombinedRelicItem)) {
            return originalEntries;
        }
        CombinedRelicItem relicItem = (CombinedRelicItem)item;
        if (this.ability.startsWith("synergy_")) {
            List<String> parents = relicItem.getSynergyParents(this.screen.stack, this.ability);
            if (parents != null && parents.size() >= 2) {
                ResourceLocation origin1 = relicItem.getAbilityOrigin(this.screen.stack, parents.get(0));
                ResourceLocation origin2 = relicItem.getAbilityOrigin(this.screen.stack, parents.get(1));
                if (origin1 != null && origin2 != null) {
                    MutableComponent abilityName1 = Component.m_237115_((String)("tooltip.relics." + origin1.m_135815_() + ".ability." + parents.get(0)));
                    MutableComponent abilityName2 = Component.m_237115_((String)("tooltip.relics." + origin2.m_135815_() + ".ability." + parents.get(1)));
                    MutableComponent title = Component.m_237113_((String)"Synergy: ").m_7220_((Component)abilityName1).m_7220_((Component)Component.m_237113_((String)" & ")).m_7220_((Component)abilityName2).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE);
                    ArrayList modifiedEntries = Lists.newArrayList((Object[])new MutableComponent[]{title});
                    if (originalEntries.size() > 1) {
                        modifiedEntries.addAll(originalEntries.subList(1, originalEntries.size()));
                    }
                    return modifiedEntries;
                }
            }
        } else {
            ResourceLocation id = relicItem.getAbilityOrigin(this.screen.stack, this.ability);
            if (id != null) {
                MutableComponent correctTitle = Component.m_237115_((String)("tooltip.relics." + id.m_135815_() + ".ability." + this.ability)).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE);
                ArrayList modifiedEntries = Lists.newArrayList((Object[])new MutableComponent[]{correctTitle});
                if (originalEntries.size() > 1) {
                    modifiedEntries.addAll(originalEntries.subList(1, originalEntries.size()));
                }
                return modifiedEntries;
            }
        }
        return originalEntries;
    }

    @Unique
    private void arcaneAbilities$drawGradientTexture(PoseStack poseStack, ResourceLocation texture, float x, float y, float width, float height, boolean leftToRight) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alphaLeft = leftToRight ? 1.0f : 0.0f;
        float alphaRight = leftToRight ? 0.0f : 1.0f;
        float x2 = x + width;
        float y2 = y + height;
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, 0.0f).m_7421_(u1, v1).m_85950_(r, g, b, alphaLeft).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x, y2, 0.0f).m_7421_(u1, v2).m_85950_(r, g, b, alphaLeft).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y2, 0.0f).m_7421_(u2, v2).m_85950_(r, g, b, alphaRight).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), x2, y, 0.0f).m_7421_(u2, v1).m_85950_(r, g, b, alphaRight).m_5752_();
        tesselator.m_85914_();
    }
}

