/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.mralxart.arcaneabilities.items.ArcaneItem;
import it.mralxart.arcaneabilities.utils.ABLootCollections;
import it.mralxart.arcaneabilities.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WeightlessBootItem
extends RelicItem
implements ArcaneItem {
    public WeightlessBootItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"light_step").maxLevel(5).active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"modifier").initialValue(10.0, 60.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"heal").initialValue(0.5, 2.0).thresholdValue(0.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).ability(AbilityData.builder((String)"parachute_descent").maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"delay").initialValue(60.0, 10.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).ability(AbilityData.builder((String)"air_strike").active(CastData.builder().type(CastType.TOGGLEABLE).build()).maxLevel(5).stat(StatData.builder((String)"radius").initialValue(2.0, 5.0).thresholdValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(x -> MathUtils.round((double)x, (int)1)).build()).stat(StatData.builder((String)"damage").initialValue(1.0, 6.0).thresholdValue(6.0, 13.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(x -> (int)MathUtils.round((double)x, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 20, 100)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-19088).borderBottom(-12751248).build()).build()).loot(LootData.builder().entry(LootCollections.COLD).entry(ABLootCollections.LEGENDARY).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("parachute_descent")) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)this.getAbilityValue(stack, "parachute_descent", "delay") * 20, 1, false, false));
            this.setAbilityCooldown(stack, "parachute_descent", (int)(this.getAbilityValue(stack, "parachute_descent", "delay") * 20.0 * 1.5));
            this.spreadExperience((LivingEntity)player, stack, 1);
        }
    }

    @Mod.EventBusSubscriber(modid="arcane_abilities", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class GeneralEvents {
        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            Player player;
            ItemStack stack;
            Item item;
            LivingEntity entity = event.getEntity();
            if (entity instanceof Player && (item = (stack = EntityUtils.findEquippedCurio((Entity)(player = (Player)entity), (Item)((Item)ItemRegistry.WEIGHTLESS_BOOT.get()))).m_41720_()) instanceof IRelicItem) {
                IRelicItem relic = (IRelicItem)item;
                if (relic.isAbilityTicking(stack, "light_step")) {
                    int level = (int)relic.getAbilityValue(stack, "light_step", "modifier");
                    float reduction = 0.1f + (float)level * 0.1f;
                    reduction = Mth.m_14036_((float)reduction, (float)0.0f, (float)0.6f);
                    event.setDamageMultiplier(1.0f - reduction);
                    player.m_5634_((float)relic.getAbilityValue(stack, "light_step", "heal"));
                }
                if (relic.isAbilityTicking(stack, "air_strike") && event.getDistance() >= 6.0f) {
                    float radius = (float)relic.getAbilityValue(stack, "air_strike", "radius");
                    ParticleUtils.spawnCylLine(player.m_9236_(), it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)Color.WHITE, (float)0.4f, (int)60, (float)0.85f), player.m_20182_(), player.m_20182_(), 20, 0.2, radius / 2.0f, radius / 2.0f);
                    for (LivingEntity entityI : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_((double)(radius / 2.0f)))) {
                        if (entityI == player) continue;
                        entityI.m_6469_(player.m_9236_().m_269111_().m_269425_(), 4.0f);
                        if (entityI.m_21224_()) continue;
                        relic.spreadExperience((LivingEntity)player, stack, 1);
                    }
                }
            }
        }
    }
}

