/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.mralxart.arcaneabilities.entities.StellarShowerEntity;
import it.mralxart.arcaneabilities.init.EntityRegistry;
import it.mralxart.arcaneabilities.items.ArcaneItem;
import it.mralxart.arcaneabilities.utils.ABLootCollections;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class StellarSphere
extends RelicItem
implements ArcaneItem {
    public StellarSphere() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"stellar_radiance").maxLevel(20).active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"radius").initialValue(1.0, 5.0).thresholdValue(1.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(x -> MathUtils.round((double)x, (int)1)).build()).stat(StatData.builder((String)"dmg").initialValue(1.0, 8.0).thresholdValue(1.0, 12.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(x -> (int)MathUtils.round((double)x, (int)1)).build()).build()).ability(AbilityData.builder((String)"stellar_ascension").maxLevel(5).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"radius").initialValue(2.0, 4.0).thresholdValue(4.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(x -> MathUtils.round((double)x, (int)1)).build()).build()).ability(AbilityData.builder((String)"stellar_shower").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).maxLevel(5).stat(StatData.builder((String)"radius").initialValue(4.0, 5.0).thresholdValue(4.0, 12.0).upgradeModifier(UpgradeOperation.ADD, 3.0).formatValue(x -> MathUtils.round((double)x, (int)1)).build()).stat(StatData.builder((String)"duration").initialValue(11.0, 16.0).thresholdValue(11.0, 26.0).upgradeModifier(UpgradeOperation.ADD, 4.0).formatValue(x -> (int)MathUtils.round((double)x, (int)1)).build()).stat(StatData.builder((String)"dmg").initialValue(6.0, 8.0).thresholdValue(6.0, 13.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(x -> (int)MathUtils.round((double)x, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 20, 100)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-224986).borderBottom(-3690896).build()).build()).loot(LootData.builder().entry(LootCollections.COLD).entry(ABLootCollections.LEGENDARY).build()).build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (player != null && !player.m_5833_()) {
            player.m_150110_().f_35935_ = false;
            player.m_6885_();
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level level = player.m_9236_();
        RandomSource random = level.f_46441_;
        if (ability.equals("stellar_shower")) {
            StellarShowerEntity shower = new StellarShowerEntity((EntityType<? extends Projectile>)((EntityType)EntityRegistry.STELLAR_SHOWER.get()), level);
            Vec3 posStorm = new Vec3(player.m_20185_(), player.m_20186_() + 40.0, player.m_20189_());
            shower.m_20219_(posStorm);
            shower.setRadius((float)this.getAbilityValue(stack, "stellar_shower", "radius"));
            shower.setLifeTime((int)(this.getAbilityValue(stack, "stellar_shower", "duration") * 20.0));
            shower.setFrequency((int)Math.round(2.0 - (double)this.getAbilityPoints(stack, "stellar_shower") * 0.7));
            shower.setDamage((float)this.getAbilityValue(stack, "stellar_shower", "dmg"));
            shower.setHeal(0.0f);
            shower.m_5602_((Entity)player);
            shower.setStack(stack);
            level.m_7967_((Entity)shower);
            this.addAbilityCooldown(stack, "stellar_shower", 600);
            this.spreadExperience((LivingEntity)player, stack, 1);
        }
        if (ability.equals("stellar_ascension")) {
            int radius = (int)this.getAbilityValue(stack, "stellar_ascension", "radius");
            Vec3 center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
            List<Entity> entities = player.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_((double)radius), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList();
            for (Entity entity : entities) {
                LivingEntity livingEntityTarget;
                if (entity == player || !(entity instanceof LivingEntity) || (livingEntityTarget = (LivingEntity)entity).m_5833_()) continue;
                livingEntityTarget.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, 40, false, false));
                livingEntityTarget.m_20256_(new Vec3(0.0, 1.5, 0.0));
            }
            this.setAbilityCooldown(stack, "stellar_ascension", 240);
            this.spreadExperience((LivingEntity)player, stack, 1);
            level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.LEAP.get(), SoundSource.MASTER, 1.0f, 1.0f + random.m_188501_() * 0.5f);
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.isAbilityTicking(stack, "stellar_radiance")) {
                this.createLightingEffect(player, stack);
                if (player.m_9236_().m_46467_() % 20L * 4L == 0L) {
                    int radius = (int)this.getAbilityValue(stack, "stellar_radiance", "radius");
                    Vec3 center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    List<Entity> entities = player.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_((double)radius), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList();
                    for (Entity entity : entities) {
                        LivingEntity livingEntityTarget;
                        if (entity == player || !(entity instanceof LivingEntity) || (livingEntityTarget = (LivingEntity)entity).m_5833_()) continue;
                        livingEntityTarget.m_6469_(player.m_9236_().m_269111_().m_269425_(), (float)this.getAbilityValue(stack, "stellar_radiance", "dmg"));
                    }
                }
            }
        }
    }

    public void createLightingEffect(Player player, ItemStack stack) {
        ParticleUtils.createCyl((ParticleOptions)ParticleUtils.constructSimpleSpark((Color)new Color(255, 255, 255), (float)0.2f, (int)0, (float)1.0f), (Vec3)player.m_20318_(1.5f), (Level)player.m_9236_(), (double)this.getAbilityValue(stack, "stellar_radiance", "radius"), (float)0.2f);
    }
}

