/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.mralxart.arcaneabilities.init.ItemRegistry;
import it.mralxart.arcaneabilities.items.ArcaneItem;
import it.mralxart.arcaneabilities.utils.ABLootCollections;
import it.mralxart.arcaneabilities.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class ShadowLantern
extends RelicItem
implements ArcaneItem {
    public ShadowLantern() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"dusk_stealth").maxLevel(4).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("dark", (player, stack) -> this.canHide((LivingEntity)player)).build()).requiredPoints(2).stat(StatData.builder((String)"light").initialValue(3.0, 8.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"delay").initialValue(32.0, 14.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"speed").initialValue(0.1, 0.35).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)(MathUtils.round((double)value, (int)3) * 100.0)).build()).build()).ability(AbilityData.builder((String)"light_beam").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"radius").initialValue(2.0, 7.0).thresholdValue(2.0, 20.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).ability(AbilityData.builder((String)"time_magic").maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"delay").initialValue(20.0, 10.0).upgradeModifier(UpgradeOperation.ADD, -1.1).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(ABLootCollections.RARE).entry(ABLootCollections.LEGENDARY).entry(LootCollections.ANTHROPOGENIC).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-4372350).borderBottom(-12442555).build()).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level world = player.m_9236_();
        if (ability.equals("dusk_stealth")) {
            int duration = (int)Math.round(this.getAbilityValue(stack, "dusk_stealth", "delay") * 20.0);
            this.setAbilityCooldown(stack, "dusk_stealth", duration * 2);
            NBTUtils.setInt((ItemStack)stack, (String)"dusk_stealth_tick", (int)200);
            Color[] colors = new Color[]{new Color(25, 9, 66), new Color(17, 3, 80), new Color(37, 0, 93), new Color(84, 16, 185)};
            ParticleUtils.addParticle(player, 10, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), colors);
        }
        if (ability.equals("time_magic")) {
            ServerLevel serverWorld;
            if (!world.m_5776_() && ShadowLantern.isDayTime(serverWorld = (ServerLevel)world)) {
                serverWorld.m_8615_(serverWorld.m_46468_() + 12000L);
                int duration = (int)Math.round(this.getAbilityValue(stack, "time_magic", "delay") * 60.0 * 20.0);
                this.setAbilityCooldown(stack, "time_magic", duration);
                this.spreadExperience((LivingEntity)player, stack, 5);
            }
            Color[] colors = new Color[]{new Color(25, 9, 66), new Color(17, 3, 80), new Color(37, 0, 93), new Color(84, 16, 185)};
            ParticleUtils.addParticle(player, 10, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), colors);
        }
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        if (!entity.m_9236_().m_5776_()) {
            int tick = NBTUtils.getInt((ItemStack)stack, (String)"dusk_stealth_tick", (int)0);
            if (tick >= 0) {
                NBTUtils.setInt((ItemStack)stack, (String)"dusk_stealth_tick", (int)(--tick));
                if (!this.canHide(entity)) {
                    EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
                } else {
                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 46, false, false));
                    float speed = (float)this.getAbilityValue(stack, "dusk_stealth", "speed");
                    EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)speed, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            } else {
                if (entity.m_21023_((MobEffect)EffectRegistry.VANISHING.get()) && entity.m_21124_((MobEffect)EffectRegistry.VANISHING.get()).m_19564_() == 46) {
                    entity.m_21195_((MobEffect)EffectRegistry.VANISHING.get());
                }
                EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
            if (this.isAbilityTicking(stack, "light_beam") && entity.m_9236_().m_46467_() % 20L == 0L) {
                int radius = (int)this.getAbilityValue(stack, "light_beam", "radius");
                Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                List<Entity> entitiesFound = entity.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_((double)radius), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList();
                for (Entity e2 : entitiesFound) {
                    LivingEntity livingEntity;
                    if (e2 == entity || !(e2 instanceof LivingEntity) || (livingEntity = (LivingEntity)e2).m_9236_().m_5776_()) continue;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30, 1, false, false));
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!ItemStack.m_41656_((ItemStack)newStack, (ItemStack)stack)) {
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    private boolean canHide(LivingEntity entity) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.SHADOW_LANTERN.get()));
        if (stack.m_41619_()) {
            return false;
        }
        Level world = entity.m_9236_();
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() + (double)entity.m_20206_() * 0.85), (double)entity.m_20189_());
        int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = world.m_45517_(LightLayer.SKY, pos);
        if (entity.m_9236_().f_46443_) {
            boolean isNight;
            float time = world.m_46942_(1.0f);
            boolean bl = isNight = time > 0.25f && time < 0.75f;
            if (isNight) {
                skyLight = 0;
            }
        } else {
            skyLight = world.m_45517_(LightLayer.SKY, pos);
            if (!ShadowLantern.isDayTime((ServerLevel)world)) {
                skyLight = 0;
            }
        }
        double totalLight = (double)blockLight + (double)skyLight * 0.5;
        double maxLight = this.getAbilityValue(stack, "dusk_stealth", "light");
        return totalLight <= maxLight;
    }

    public static boolean isDayTime(ServerLevel level) {
        long timeOfDay = level.m_46468_() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 12000L;
    }
}

