/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.arcaneabilities.items.relics;

import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.mralxart.arcaneabilities.entities.SnowballEntity;
import it.mralxart.arcaneabilities.entities.VortexEntity;
import it.mralxart.arcaneabilities.init.EntityRegistry;
import it.mralxart.arcaneabilities.items.ArcaneItem;
import it.mralxart.arcaneabilities.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class IcyCrystal
extends RelicItem
implements ArcaneItem {
    public IcyCrystal() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"snowy_whirlwind").maxLevel(4).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredPoints(2).stat(StatData.builder((String)"radius").initialValue(3.0, 8.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"dmg").initialValue(32.0, 14.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).ability(AbilityData.builder((String)"frosty_shackles").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"duration").initialValue(4.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"radius").initialValue(3.0, 7.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).ability(AbilityData.builder((String)"icy_projectiles").maxLevel(2).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"size").initialValue(14.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"damage").initialValue(30.0, 20.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"delay").initialValue(15.0, 10.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-3876112).borderBottom(-12743977).build()).build()).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level level = player.m_9236_();
        if (ability.equals("icy_projectiles")) {
            SnowballEntity entity = new SnowballEntity(level);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)entity);
            level.m_5594_(null, player.m_20097_(), SoundEvents.f_12473_, SoundSource.PLAYERS, 0.5f, 0.5f);
            this.spreadExperience((LivingEntity)player, stack, 1);
            int duration = (int)Math.round(this.getAbilityValue(stack, "icy_projectiles", "delay") * 20.0);
            this.setAbilityCooldown(stack, "icy_projectiles", duration);
        }
        if (ability.equals("frosty_shackles")) {
            double radius = this.getAbilityValue(stack, "frosty_shackles", "radius");
            double duration = this.getAbilityValue(stack, "frosty_shackles", "duration") * 20.0;
            for (LivingEntity entity : level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(radius))) {
                if (entity.m_20148_().equals(player.m_20148_())) continue;
                entity.m_146917_((int)duration);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)duration, 255, false, false));
            }
            this.addAbilityCooldown(stack, "frosty_shackles", (int)(duration * 2.0));
            this.spreadExperience((LivingEntity)player, stack, 2);
        }
        if (ability.equals("snowy_whirlwind")) {
            VortexEntity shower = new VortexEntity((EntityType<? extends Projectile>)((EntityType)EntityRegistry.VORTEX.get()), player.m_9236_());
            Vec3 posStorm = new Vec3(player.m_20185_(), player.m_20186_() + 30.0, player.m_20189_());
            shower.m_146884_(posStorm);
            shower.setRadius((float)this.getAbilityValue(stack, "snowy_whirlwind", "radius"));
            shower.setFrequency((int)Math.round(4.0 - (double)this.getAbilityPoints(stack, "stellar_shower") * 0.7));
            shower.setDamage((float)this.getAbilityValue(stack, "snowy_whirlwind", "dmg") + (float)stack.getEnchantmentLevel(Enchantments.f_44977_) / 2.5f);
            shower.m_5602_((Entity)player);
            shower.setStack(stack);
            level.m_7967_((Entity)shower);
            this.addAbilityCooldown(stack, "snowy_whirlwind", 600);
            this.spreadExperience((LivingEntity)player, stack, 2);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.m_9236_();
            double radius = this.getAbilityValue(stack, "frosty_shackles", "radius");
            Color color1 = Color.CYAN;
            for (LivingEntity target : level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(radius))) {
                if (target.m_20148_().equals(player.m_20148_()) || !target.m_21023_(MobEffects.f_19597_)) continue;
                ParticleUtils.particleAABB(level, it.hurts.sskirillss.relics.utils.ParticleUtils.constructSimpleSpark((Color)color1, (float)0.1f, (int)20, (float)0.85f), target.m_20191_(), 1, 0.05, target.m_20185_(), target.m_20186_(), target.m_20189_());
            }
        }
    }
}

